/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.gametest;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;

public class GameTestLoaderHelpers {
    public static Collection<TestFunction> generateCommonTests(String modId, Class<?>[] testClasses) throws InstantiationException, IllegalAccessException {
        ArrayList testsList = Lists.newArrayList();
        for (Class<?> clazz : testClasses) {
            Object instance = clazz.newInstance();
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(GameTest.class)) continue;
                GameTest gameTest = method.getAnnotation(GameTest.class);
                testsList.add(new TestFunction(modId, modId + "." + method.getName(), gameTest.template(), StructureUtils.getRotationForRotationSteps((int)gameTest.rotationSteps()), gameTest.timeoutTicks(), gameTest.setupTicks(), gameTest.required(), gameTest.manualOnly(), gameTest.attempts(), gameTest.requiredSuccesses(), gameTest.skyAccess(), gameTestHelpers -> {
                    try {
                        method.invoke(instance, gameTestHelpers);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                        throw new GameTestAssertException(e.getMessage());
                    }
                }));
            }
        }
        return testsList;
    }
}

