/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class RecipeCraftingShapelessCustomOutput
extends ShapelessRecipe {
    private final Serializer serializer;
    private final ItemStack recipeOutput;

    public RecipeCraftingShapelessCustomOutput(Serializer serializer, String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(groupIn, category, recipeOutputIn, recipeItemsIn);
        this.serializer = serializer;
        this.recipeOutput = recipeOutputIn;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        Serializer.IOutputTransformer outputTransformer = this.serializer.getOutputTransformer();
        if (outputTransformer != null) {
            return outputTransformer.transform(inv, this.getResultItem());
        }
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getResultItem();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCraftingShapelessCustomOutput> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crafting_shapeless");
        private final Supplier<ItemStack> outputProvider;
        @Nullable
        private final IOutputTransformer outputTransformer;
        private final MapCodec<RecipeCraftingShapelessCustomOutput> codec;
        private final StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapelessCustomOutput> streamCodec;

        public Serializer(Supplier<ItemStack> outputProvider, @Nullable IOutputTransformer outputTransformer) {
            this.outputProvider = outputProvider;
            this.outputTransformer = outputTransformer;
            this.codec = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
                Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
                if (aingredient.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless recipe");
                }
                return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
            }, DataResult::success).forGetter(p_300975_ -> p_300975_.getIngredients())).apply((Applicative)p_311734_, (group, category, ingredients) -> new RecipeCraftingShapelessCustomOutput(this, (String)group, (CraftingBookCategory)category, this.outputProvider.get(), (NonNullList<Ingredient>)ingredients)));
            this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
        }

        public Serializer(Supplier<ItemStack> outputProvider) {
            this(outputProvider, null);
        }

        @Nullable
        public IOutputTransformer getOutputTransformer() {
            return this.outputTransformer;
        }

        public MapCodec<RecipeCraftingShapelessCustomOutput> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeCraftingShapelessCustomOutput> streamCodec() {
            return this.streamCodec;
        }

        private RecipeCraftingShapelessCustomOutput fromNetwork(RegistryFriendlyByteBuf p_319905_) {
            String s = p_319905_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319905_.readEnum(CraftingBookCategory.class);
            int i = p_319905_.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_319905_));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319905_);
            return new RecipeCraftingShapelessCustomOutput(this, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private void toNetwork(RegistryFriendlyByteBuf p_320371_, RecipeCraftingShapelessCustomOutput p_320323_) {
            p_320371_.writeUtf(p_320323_.getGroup());
            p_320371_.writeEnum((Enum)p_320323_.category());
            p_320371_.writeVarInt(p_320323_.getIngredients().size());
            for (Ingredient ingredient : p_320323_.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320371_, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)p_320371_, (Object)p_320323_.getResultItem());
        }

        public static interface IOutputTransformer {
            public ItemStack transform(CraftingInput var1, ItemStack var2);
        }
    }
}

