/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.model.tools;

import net.minecraft.util.Mth;

public class ControlledAnimation {
    private int timer = 0;
    private int duration;
    private int timerChange;

    public ControlledAnimation(int d) {
        this.duration = d;
    }

    public void setDuration(int d) {
        this.timer = 0;
        this.duration = d;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int time) {
        this.timer = time;
        if (this.timer > this.duration) {
            this.timer = this.duration;
        } else if (this.timer < 0) {
            this.timer = 0;
        }
    }

    public void resetTimer() {
        this.timer = 0;
    }

    public void increaseTimer() {
        if (this.timer < this.duration) {
            ++this.timer;
            this.timerChange = 1;
        }
    }

    public boolean canIncreaseTimer() {
        return this.timer < this.duration;
    }

    public void increaseTimer(int time) {
        int newTime = this.timer + time;
        this.timer = newTime <= this.duration && newTime >= 0 ? newTime : (newTime < 0 ? 0 : this.duration);
    }

    public void decreaseTimer() {
        if ((double)this.timer > 0.0) {
            --this.timer;
            this.timerChange = -1;
        }
    }

    public boolean canDecreaseTimer() {
        return (double)this.timer > 0.0;
    }

    public void decreaseTimer(int time) {
        this.timer = (double)(this.timer - time) > 0.0 ? (this.timer -= time) : 0;
    }

    public float getAnimationFraction() {
        return (float)this.timer / (float)this.duration;
    }

    public float getAnimationProgressSmooth() {
        if ((double)this.timer > 0.0) {
            if (this.timer < this.duration) {
                return (float)(1.0 / (1.0 + Math.exp(4.0 - 8.0 * (double)this.getAnimationFraction())));
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public float getAnimationProgressSteep() {
        return (float)(1.0 / (1.0 + Math.exp(6.0 - 12.0 * (double)this.getAnimationFraction())));
    }

    public float getAnimationProgressSin() {
        return Mth.sin((float)(1.5707964f * this.getAnimationFraction()));
    }

    public float getAnimationProgressSinSqrt() {
        float result = Mth.sin((float)(1.5707964f * this.getAnimationFraction()));
        return result * result;
    }

    public float getAnimationProgressSinToTen() {
        return (float)Math.pow(Mth.sin((float)(1.5707964f * this.getAnimationFraction())), 10.0);
    }

    public float getAnimationProgressSinToTenWithoutReturn() {
        if (this.timerChange == -1) {
            return Mth.sin((float)(1.5707964f * this.getAnimationFraction())) * Mth.sin((float)(1.5707964f * this.getAnimationFraction()));
        }
        return (float)Math.pow(Mth.sin((float)(1.5707964f * this.getAnimationFraction())), 10.0);
    }

    public float getAnimationProgressSinPowerOf(int i) {
        return (float)Math.pow(Mth.sin((float)(1.5707964f * this.getAnimationFraction())), i);
    }

    public float getAnimationProgressPoly2() {
        float x = this.getAnimationFraction();
        float x2 = x * x;
        return x2 / (x2 + (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPoly3() {
        float x = this.getAnimationFraction();
        float x3 = x * x * x;
        return x3 / (x3 + (1.0f - x) * (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPolyN(int n) {
        double x = this.getAnimationFraction();
        double xi = Math.pow(x, n);
        return (float)(xi / (xi + Math.pow(1.0 - x, n)));
    }

    public float getAnimationProgressArcTan() {
        return (float)(0.5 + (double)0.4980651f * Math.atan(3.14159265359 * ((double)this.getAnimationFraction() - 0.5)));
    }

    public float getAnimationProgressTemporary() {
        float x = (float)Math.PI * 2 * this.getAnimationFraction();
        return 0.5f - 0.5f * Mth.cos((float)(x + Mth.sin((float)x)));
    }

    public float getAnimationProgressTemporaryFS() {
        float x = (float)Math.PI * this.getAnimationFraction();
        return Mth.sin((float)(x + Mth.sin((float)x)));
    }

    public float getAnimationProgressTemporaryInvesed() {
        float x = (float)Math.PI * 2 * this.getAnimationFraction();
        return 0.5f + 0.5f * Mth.cos((float)(x + Mth.sin((float)x)));
    }
}

