/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.ApiStatus;

public class SkullRenderRegistry {
    private static final List<SkullInfoWithModel> SKULL_INFO_WITH_MODEL = new ArrayList<SkullInfoWithModel>();
    private static final List<SkullInfoWithLayer> SKULL_INFO_WITH_LAYER = new ArrayList<SkullInfoWithLayer>();

    public static void register(SkullBlock.Type type, ResourceLocation texture, Block ... blocks) {
        SkullRenderRegistry.register(type, texture, ModelLayers.ZOMBIE_HEAD, blocks);
    }

    public static void register(SkullBlock.Type type, ResourceLocation texture, ModelLayerLocation layer, Block ... blocks) {
        SKULL_INFO_WITH_LAYER.add(new SkullInfoWithLayer(type, texture, layer, List.of(blocks)));
    }

    public static void register(SkullBlock.Type type, ResourceLocation texture, SkullModelBase model, Block ... blocks) {
        SKULL_INFO_WITH_MODEL.add(new SkullInfoWithModel(type, texture, model, List.of(blocks)));
    }

    @ApiStatus.Internal
    public static ImmutableMap<SkullBlock.Type, SkullModelBase> getSkulls(Map<SkullBlock.Type, ResourceLocation> textures, EntityModelSet modelLoader) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SkullInfoWithModel skullInfoWithModel : SKULL_INFO_WITH_MODEL) {
            textures.put(skullInfoWithModel.type, skullInfoWithModel.texture);
            builder.put((Object)skullInfoWithModel.type, (Object)skullInfoWithModel.model);
        }
        for (SkullInfoWithLayer skullInfoWithLayer : SKULL_INFO_WITH_LAYER) {
            textures.put(skullInfoWithLayer.type, skullInfoWithLayer.texture);
            builder.put((Object)skullInfoWithLayer.type, (Object)new SkullModel(modelLoader.bakeLayer(skullInfoWithLayer.layer)));
        }
        return builder.build();
    }

    @ApiStatus.Internal
    public static boolean supported(Block block) {
        for (SkullInfoWithModel skullInfoWithModel : SKULL_INFO_WITH_MODEL) {
            if (!skullInfoWithModel.blocks.contains(block)) continue;
            return true;
        }
        for (SkullInfoWithLayer skullInfoWithLayer : SKULL_INFO_WITH_LAYER) {
            if (!skullInfoWithLayer.blocks.contains(block)) continue;
            return true;
        }
        return false;
    }

    private record SkullInfoWithLayer(SkullBlock.Type type, ResourceLocation texture, ModelLayerLocation layer, List<Block> blocks) {
    }

    private record SkullInfoWithModel(SkullBlock.Type type, ResourceLocation texture, SkullModelBase model, List<Block> blocks) {
    }
}

