/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.collision;

import com.iafenvoy.uranus.object.PathUtil;
import com.iafenvoy.uranus.object.entity.collision.ICustomCollisions;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class CustomCollisionsNodeProcessor
extends WalkNodeEvaluator {
    public static PathType getLandNodeType(PathfindingContext context, BlockPos.MutableBlockPos mutable) {
        int i = mutable.getX();
        int j = mutable.getY();
        int k = mutable.getZ();
        PathType pathnodetype = CustomCollisionsNodeProcessor.getNodes(context, (BlockPos)mutable);
        if (pathnodetype == PathType.OPEN && j >= 1) {
            PathType nodes = CustomCollisionsNodeProcessor.getNodes(context, (BlockPos)mutable.set(i, j - 1, k));
            PathType pathType = pathnodetype = nodes != PathType.WALKABLE && nodes != PathType.OPEN && nodes != PathType.WATER && nodes != PathType.LAVA ? PathType.WALKABLE : PathType.OPEN;
            if (nodes == PathType.DAMAGE_FIRE) {
                pathnodetype = PathType.DAMAGE_FIRE;
            }
            if (nodes == PathType.DAMAGE_OTHER) {
                pathnodetype = PathType.DAMAGE_OTHER;
            }
            if (nodes == PathType.STICKY_HONEY) {
                pathnodetype = PathType.STICKY_HONEY;
            }
        }
        if (pathnodetype == PathType.WALKABLE) {
            pathnodetype = CustomCollisionsNodeProcessor.checkNeighbourBlocks((PathfindingContext)context, (int)i, (int)j, (int)k, (PathType)pathnodetype);
        }
        return pathnodetype;
    }

    protected static PathType getNodes(PathfindingContext p_237238_0_, BlockPos p_237238_1_) {
        BlockState blockstate = p_237238_0_.getBlockState(p_237238_1_);
        PathType type = PathUtil.getAiPathNodeType(blockstate, (LevelReader)p_237238_0_, p_237238_1_);
        if (type != null) {
            return type;
        }
        if (blockstate.isAir()) {
            return PathType.OPEN;
        }
        if (blockstate.getBlock() == Blocks.BAMBOO) {
            return PathType.OPEN;
        }
        return CustomCollisionsNodeProcessor.getPathTypeFromState((BlockGetter)p_237238_0_.level(), (BlockPos)p_237238_1_);
    }

    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        return CustomCollisionsNodeProcessor.getLandNodeType(context, new BlockPos.MutableBlockPos(x, y, z));
    }

    public Set<PathType> getPathTypeWithinMobBB(PathfindingContext context, int x, int y, int z) {
        BlockState state = context.getBlockState(context.mobPosition());
        return ((ICustomCollisions)this.mob).canPassThrough(context.mobPosition(), state, state.getBlockSupportShape((BlockGetter)context.level(), context.mobPosition())) ? Set.of(PathType.OPEN) : super.getPathTypeWithinMobBB(context, x, y, z);
    }
}

