/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.content.kinetics.fan.processing;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlock;
import net.davio.aquaticambitions.content.processing.conduit.MechanicalConduitBlockEntity;
import net.davio.aquaticambitions.registry.CAARecipeTypes;
import net.davio.aquaticambitions.registry.CAATags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChannelingFanProcessingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        if (this.checkForActiveConduit(level, pos)) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        FluidState fluidState = level.getFluidState(pos);
        BlockState blockState = level.getBlockState(pos);
        return CAATags.CAABlockTags.FAN_PROCESSING_CATALYSTS_CHANNELING.matches(blockState) || CAATags.CAAFluidTags.FAN_PROCESSING_CATALYSTS_CHANNELING.matches(fluidState);
    }

    public int getPriority() {
        return 1200;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CAARecipeTypes.CHANNELING.getType(), (RecipeInput)input, level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        RecipeManager recipeManager = level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(stack);
        return recipeManager.getRecipeFor(CAARecipeTypes.CHANNELING.getType(), (RecipeInput)input, level).map(recipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipe.value(), (boolean)true)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) != 0) {
            return;
        }
        Vector3f color = new Color(22015).asVectorF();
        level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        if (level.random.nextInt(8) < 2) {
            level.addParticle((ParticleOptions)ParticleTypes.NAUTILUS, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), (double)(level.random.nextFloat() - 0.5f), (double)(level.random.nextFloat() - 0.5f), (double)(level.random.nextFloat() - 0.5f));
        } else if (level.random.nextInt(8) < 4) {
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), (double)(level.random.nextFloat() - 0.5f), (double)(level.random.nextFloat() - 0.5f), (double)(level.random.nextFloat() - 0.5f));
        }
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)2070193, (int)22015, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
        if (random.nextFloat() < 0.00390625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.ENCHANT, 0.125f);
        }
        if (random.nextFloat() < 9.765625E-4f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.NAUTILUS, 0.075f);
        }
        if (random.nextFloat() < 0.015625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.BUBBLE, 0.125f);
        }
        if (random.nextFloat() < 0.015625f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof Player) {
            ((Player)entity).addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true));
        }
    }

    public boolean checkForActiveConduit(Level level, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos adjacentPos = pos.offset(i, j, k);
                    BlockEntity blockEntity = level.getBlockEntity(adjacentPos);
                    if (!(blockEntity instanceof ConduitBlockEntity) || !((ConduitBlockEntity)blockEntity).isActive()) continue;
                    return true;
                }
            }
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && blockEntity instanceof MechanicalConduitBlockEntity) {
            MechanicalConduitBlock.ConduitPowerLevel powerLevel = ((MechanicalConduitBlockEntity)blockEntity).getConduitLevelFromBlock();
            return powerLevel == MechanicalConduitBlock.ConduitPowerLevel.AWAKENED;
        }
        return false;
    }
}

