/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.client.util;

import cy.jdkdigital.dyenamics.Dyenamics;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicBannerRenderer;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicBedRenderer;
import cy.jdkdigital.dyenamics.client.render.block.DyenamicShulkerBoxBlockEntityRenderer;
import cy.jdkdigital.dyenamics.client.render.entity.DyenamicSheepRenderer;
import cy.jdkdigital.dyenamics.core.init.BlockEntityInit;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.EntityInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="dyenamics", bus=EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.BED.get(), DyenamicBedRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.SHULKER_BOX.get(), DyenamicShulkerBoxBlockEntityRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.SHEEP.get(), DyenamicSheepRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityInit.BANNER.get(), DyenamicBannerRenderer::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass").get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass_pane").get()), (RenderType)RenderType.translucent());
            Dyenamics.BED_MATERIAL_MAP.put(color.getSerializedName(), new Material(Sheets.BED_SHEET, ResourceLocation.fromNamespaceAndPath((String)"dyenamics", (String)("entity/bed/" + color.getSerializedName()))));
            Dyenamics.SHULKER_MATERIAL_MAP.put(color.getSerializedName(), new Material(Sheets.SHULKER_SHEET, ResourceLocation.fromNamespaceAndPath((String)"dyenamics", (String)("entity/shulker/" + color.getSerializedName()))));
        }
    }
}

