/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.core.init;

import cy.jdkdigital.dyenamics.common.block.DyenamicBannerBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicBedBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicCarpetBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicShulkerBoxBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamics.common.block.DyenamicStainedGlassPane;
import cy.jdkdigital.dyenamics.common.block.DyenamicWallBannerBlock;
import cy.jdkdigital.dyenamics.common.item.DyenamicBannerItem;
import cy.jdkdigital.dyenamics.common.item.DyenamicBedBlockItem;
import cy.jdkdigital.dyenamics.common.item.DyenamicShulkerBlockItem;
import cy.jdkdigital.dyenamics.core.init.ItemInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"dyenamics");
    public static final Map<String, Map<String, DeferredHolder<Block, Block>>> DYED_BLOCKS = new HashMap<String, Map<String, DeferredHolder<Block, Block>>>();

    public static void register() {
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            BlockInit.registerDyeBlocks(color);
        }
    }

    public static synchronized void registerDyeBlocks(DyenamicDyeColor color) {
        String colorName = color.getSerializedName();
        int light = color.getLightValue();
        MapColor mapColor = color.getMapColor();
        DyeColor analogue = color.getAnalogue();
        HashMap<String, DeferredHolder<Block, Block>> blocks = new HashMap<String, DeferredHolder<Block, Block>>();
        DYED_BLOCKS.put(colorName, blocks);
        BlockInit.registerBlockAndItem(colorName, "terracotta", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_TERRACOTTA).mapColor(mapColor).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "glazed_terracotta", blocks, BlockItem::new, () -> new GlazedTerracottaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_GLAZED_TERRACOTTA).mapColor(analogue).lightLevel(state -> light)));
        DeferredHolder<Block, Block> concrete = BlockInit.registerBlockAndItem(colorName, "concrete", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE).mapColor(analogue).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "concrete_powder", blocks, BlockItem::new, () -> new ConcretePowderBlock((Block)concrete.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CONCRETE_POWDER).mapColor(analogue).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "wool", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).mapColor(mapColor).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "rockwool", blocks, BlockItem::new, () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(2.0f, 6.0f).sound(SoundType.WOOL).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "carpet", blocks, BlockItem::new, () -> new DyenamicCarpetBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_CARPET).mapColor(mapColor).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass", blocks, BlockItem::new, () -> new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS).mapColor(mapColor).lightLevel(state -> light)));
        BlockInit.registerBlockAndItem(colorName, "stained_glass_pane", blocks, BlockItem::new, () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_STAINED_GLASS_PANE).mapColor(mapColor).lightLevel(state -> light)));
        DeferredHolder<Block, Block> candle = BlockInit.registerBlockAndItem(colorName, "candle", blocks, BlockItem::new, () -> new CandleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CANDLE).mapColor(mapColor).lightLevel(state -> {
            int candleLight = CandleBlock.LIGHT_EMISSION.applyAsInt(state);
            return Math.max(light, candleLight);
        })));
        BlockInit.registerBlockAndItem(colorName, "candle_cake", blocks, null, () -> new CandleCakeBlock((Block)candle.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CANDLE_CAKE).lightLevel(state -> light > 0 ? light : ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 3 : 0))));
        BlockInit.registerBedAndItem(colorName, "bed", blocks, DyenamicBedBlockItem::new, () -> new DyenamicBedBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_BED).mapColor(state -> state.getValue((Property)BedBlock.PART) == BedPart.FOOT ? mapColor : MapColor.WOOL).lightLevel(state -> light)));
        BlockInit.registerShulkerBoxAndItem(colorName, "shulker_box", blocks, DyenamicShulkerBlockItem::new, () -> new DyenamicShulkerBoxBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHULKER_BOX).lightLevel(state -> light).mapColor(mapColor)));
        DeferredHolder<Block, Block> wallBanner = BlockInit.registerBlockAndItem(colorName, "wall_banner", blocks, null, () -> new DyenamicWallBannerBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_BANNER).lightLevel(state -> light)));
        BlockInit.registerBannerBlockAndItem(colorName, "banner", blocks, () -> new DyenamicBannerBlock(color, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_BANNER).lightLevel(state -> light)), wallBanner);
    }

    public static synchronized DeferredHolder<Block, Block> registerBedAndItem(String color, String nameSuffix, Map<String, DeferredHolder<Block, Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().stacksTo(1));
    }

    public static synchronized DeferredHolder<Block, Block> registerShulkerBoxAndItem(String color, String nameSuffix, Map<String, DeferredHolder<Block, Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties().stacksTo(1));
    }

    public static synchronized DeferredHolder<Block, Block> registerBlockAndItem(String color, String nameSuffix, Map<String, DeferredHolder<Block, Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier) {
        return BlockInit.registerBlockAndItem(color, nameSuffix, blockMap, itemSupplier, supplier, new Item.Properties());
    }

    public static synchronized DeferredHolder<Block, Block> registerBlockAndItem(String color, String nameSuffix, Map<String, DeferredHolder<Block, Block>> blockMap, BlockItemSupplier<?> itemSupplier, Supplier<Block> supplier, Item.Properties itemProperties) {
        String name = color + "_" + nameSuffix;
        DeferredHolder block = BLOCKS.register(name, supplier);
        if (itemSupplier != null) {
            ItemInit.ITEMS.register(name, () -> itemSupplier.create((Block)block.get(), itemProperties));
        }
        blockMap.put(nameSuffix, (DeferredHolder<Block, Block>)block);
        return block;
    }

    public static synchronized DeferredHolder<Block, Block> registerBannerBlockAndItem(String color, String nameSuffix, Map<String, DeferredHolder<Block, Block>> blockMap, Supplier<Block> banner, DeferredHolder<Block, Block> wallBanner) {
        String name = color + "_" + nameSuffix;
        DeferredHolder block = BLOCKS.register(name, banner);
        ItemInit.ITEMS.register(name, () -> new DyenamicBannerItem((Block)block.get(), (Block)wallBanner.get(), new Item.Properties().stacksTo(16).component(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY)));
        blockMap.put(nameSuffix, (DeferredHolder<Block, Block>)block);
        return block;
    }

    @FunctionalInterface
    public static interface BlockItemSupplier<T extends BlockItem> {
        public T create(Block var1, Item.Properties var2);
    }
}

