/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.init.ItemInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        generator.registerStatesAndModels(blockStateOutput, modelOutput);
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            this.createBedItem((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("bed").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get(), modelOutput);
            this.createBannerItem((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("banner").get(), modelOutput);
            this.createShulkerBox((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("shulker_box").get(), modelOutput);
            this.createSimpleFlatItemModel(((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle").get()).asItem(), modelOutput);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get(), itemModels);
            this.addOtherBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("rockwool").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("carpet").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("terracotta").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("glazed_terracotta").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete_powder").get(), itemModels);
            this.addBlockItemParentModel((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass").get(), itemModels);
            this.createSimpleFlatItemModel((Item)ItemInit.DYE_ITEMS.get(color.getSerializedName() + "_dye").get(), modelOutput);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemParentModel(Block block, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/" + p)), itemModels);
        }
    }

    private void addOtherBlockItemParentModel(Block block, Block otherBlock, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(BuiltInRegistries.BLOCK.getKey((Object)otherBlock).withPath(p -> "block/" + p)), itemModels);
        }
    }

    private void createSimpleFlatItemModel(Item pFlatItem, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)pFlatItem), TextureMapping.layer0((Item)pFlatItem), itemModels);
    }

    private void createBedItem(Block pBedBlock, Block pWoolBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.BED_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)pBedBlock.asItem()), TextureMapping.particle((Block)pWoolBlock), itemModels);
    }

    private void createBannerItem(Block pBedBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.BANNER_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)pBedBlock.asItem()), TextureMapping.particle((Block)Blocks.OAK_PLANKS), itemModels);
    }

    private void createShulkerBox(Block pShulkerBoxBlock, BiConsumer<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ModelTemplates.SHULKER_BOX_INVENTORY.create(ModelLocationUtils.getModelLocation((Item)pShulkerBoxBlock.asItem()), TextureMapping.particle((Block)pShulkerBoxBlock), itemModels);
    }

    public String getName() {
        return "Dyenamics Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("bed").get(), ModelLocationUtils.decorateBlockModelLocation((String)"bed")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("banner").get(), ModelLocationUtils.decorateBlockModelLocation((String)"banner")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createEntityBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wall_banner").get(), ModelLocationUtils.decorateBlockModelLocation((String)"banner")));
                this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("shulker_box").get(), TexturedModel.PARTICLE_ONLY.create((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("shulker_box").get(), this.modelOutput)));
                this.createCandleAndCandleCake((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle_cake").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get());
                this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("rockwool").get(), ModelLocationUtils.getModelLocation((Block)((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get()))));
                this.createCarpetBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("carpet").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("terracotta").get());
                this.createColoredBlockWithStateRotations((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("glazed_terracotta").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete").get());
                this.createCubeBlock((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete_powder").get());
                this.createGlassBlocks((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass_pane").get());
            }
        }

        private void createCubeBlock(Block pBlock) {
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(pBlock, ModelTemplates.CUBE_ALL.create(pBlock, TextureMapping.defaultTexture((Block)pBlock).put(TextureSlot.ALL, ModelLocationUtils.getModelLocation((Block)pBlock)), this.modelOutput)));
        }

        private void createGlassBlock(Block pBlock) {
            ModelTemplate template = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"dyenamics", (String)"block/stained_glass")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(pBlock, template.create(pBlock, TextureMapping.defaultTexture((Block)pBlock).put(TextureSlot.ALL, ModelLocationUtils.getModelLocation((Block)pBlock)), this.modelOutput)));
        }

        private void createColoredBlockWithStateRotations(Block pBlock) {
            ResourceLocation resourcelocation = TexturedModel.GLAZED_TERRACOTTA.create(pBlock, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation)).with(ModelGenerator.createHorizontalFacingDispatchAlt()));
        }

        private static PropertyDispatch createHorizontalFacingDispatchAlt() {
            return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.SOUTH, Variant.variant()).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
        }

        private MultiVariantGenerator createEntityBlock(Block pBlock, ResourceLocation pBaseModel) {
            return MultiVariantGenerator.multiVariant((Block)pBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)pBaseModel));
        }

        private MultiVariantGenerator createSimpleBlock(Block pBlock, ResourceLocation pModelLocation) {
            return MultiVariantGenerator.multiVariant((Block)pBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)pModelLocation));
        }

        private void createCarpetBlock(Block wool, Block carpet) {
            ResourceLocation resourcelocation = TexturedModel.CARPET.get(wool).create(carpet, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)this.createSimpleBlock(carpet, resourcelocation));
        }

        private void createCandleAndCandleCake(Block pCandleBlock, Block pCandleCakeBlock) {
            TextureMapping candleTextureMapping = TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)pCandleBlock));
            TextureMapping litCandleTextureMapping = TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)pCandleBlock, (String)"_lit"));
            ResourceLocation oneCandle = ModelTemplates.CANDLE.createWithSuffix(pCandleBlock, "_one_candle", candleTextureMapping, this.modelOutput);
            ResourceLocation twoCandles = ModelTemplates.TWO_CANDLES.createWithSuffix(pCandleBlock, "_two_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation threeCandles = ModelTemplates.THREE_CANDLES.createWithSuffix(pCandleBlock, "_three_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation fourCandles = ModelTemplates.FOUR_CANDLES.createWithSuffix(pCandleBlock, "_four_candles", candleTextureMapping, this.modelOutput);
            ResourceLocation oneCandleLit = ModelTemplates.CANDLE.createWithSuffix(pCandleBlock, "_one_candle_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation twoCandlesLit = ModelTemplates.TWO_CANDLES.createWithSuffix(pCandleBlock, "_two_candles_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation threeCandlesLit = ModelTemplates.THREE_CANDLES.createWithSuffix(pCandleBlock, "_three_candles_lit", litCandleTextureMapping, this.modelOutput);
            ResourceLocation fourCandlesLit = ModelTemplates.FOUR_CANDLES.createWithSuffix(pCandleBlock, "_four_candles_lit", litCandleTextureMapping, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pCandleBlock).with((PropertyDispatch)PropertyDispatch.properties((Property)BlockStateProperties.CANDLES, (Property)BlockStateProperties.LIT).select((Comparable)Integer.valueOf(1), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)oneCandle)).select((Comparable)Integer.valueOf(2), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)twoCandles)).select((Comparable)Integer.valueOf(3), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)threeCandles)).select((Comparable)Integer.valueOf(4), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)fourCandles)).select((Comparable)Integer.valueOf(1), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)oneCandleLit)).select((Comparable)Integer.valueOf(2), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)twoCandlesLit)).select((Comparable)Integer.valueOf(3), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)threeCandlesLit)).select((Comparable)Integer.valueOf(4), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)fourCandlesLit))));
            ResourceLocation candleCake = ModelTemplates.CANDLE_CAKE.create(pCandleCakeBlock, TextureMapping.candleCake((Block)pCandleBlock, (boolean)false), this.modelOutput);
            ResourceLocation candleCakeLit = ModelTemplates.CANDLE_CAKE.createWithSuffix(pCandleCakeBlock, "_lit", TextureMapping.candleCake((Block)pCandleBlock, (boolean)true), this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pCandleCakeBlock).with(ModelGenerator.createBooleanModelDispatch(BlockStateProperties.LIT, candleCakeLit, candleCake)));
        }

        private void createGlassBlocks(Block pGlassBlock, Block pPaneBlock) {
            this.createGlassBlock(pGlassBlock);
            TextureMapping texturemapping = TextureMapping.pane((Block)pGlassBlock, (Block)pPaneBlock);
            ResourceLocation panePost = ModelTemplates.STAINED_GLASS_PANE_POST.create(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneSide = ModelTemplates.STAINED_GLASS_PANE_SIDE.create(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneSideAlt = ModelTemplates.STAINED_GLASS_PANE_SIDE_ALT.create(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation pandNoside = ModelTemplates.STAINED_GLASS_PANE_NOSIDE.create(pPaneBlock, texturemapping, this.modelOutput);
            ResourceLocation paneNosideAlt = ModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT.create(pPaneBlock, texturemapping, this.modelOutput);
            Item item = pPaneBlock.asItem();
            ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Block)pGlassBlock), this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiPartGenerator.multiPart((Block)pPaneBlock).with(Variant.variant().with(VariantProperties.MODEL, (Object)panePost)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)paneSide)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)paneSide).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)paneSideAlt)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)paneSideAlt).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)pandNoside)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)paneNosideAlt)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)paneNosideAlt).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)pandNoside).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)));
        }

        private static PropertyDispatch createBooleanModelDispatch(BooleanProperty pProperty, ResourceLocation pTrueModelLocation, ResourceLocation pFalseModelLocation) {
            return PropertyDispatch.property((Property)pProperty).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)pTrueModelLocation)).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)pFalseModelLocation));
        }
    }
}

