/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.data;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Dyenamics Loot Datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class EntityLootProvider
    extends EntityLootSubProvider {
        List<EntityType<?>> knownEntities = new ArrayList();

        public EntityLootProvider(HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            for (DyenamicDyeColor dyenamicDyeColor : DyenamicDyeColor.dyenamicValues()) {
            }
        }

        private void addSheep(DyenamicDyeColor color) {
            Block item = (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get();
            LootTable.Builder loot = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
            this.add(EntityType.SHEEP, loot);
        }

        protected void add(EntityType<?> pEntityType, LootTable.Builder pBuilder) {
            super.add(pEntityType, pBuilder);
            this.knownEntities.add(pEntityType);
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return this.knownEntities.stream();
        }
    }

    public static class BlockProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public BlockProvider(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
                this.dropBanner((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("banner").get());
                this.add((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("bed").get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
                this.add((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle").get(), (Block x$0) -> this.createCandleDrops((Block)x$0));
                this.add((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle_cake").get(), BlockProvider.createCandleCakeDrops((Block)((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("candle_cake").get())));
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("carpet").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("concrete_powder").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("glazed_terracotta").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("rockwool").get());
                this.add((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("shulker_box").get(), (Block x$0) -> this.createShulkerBoxDrop((Block)x$0));
                this.dropWhenSilkTouch((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass").get());
                this.dropWhenSilkTouch((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("stained_glass_pane").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("terracotta").get());
                this.dropOtherBanner((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wall_banner").get(), (Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("banner").get());
                this.dropSelf((Block)BlockInit.DYED_BLOCKS.get(color.getSerializedName()).get("wool").get());
            }
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        public void dropSelf(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genOptionalBlockDrop);
            this.add(block, func.apply(block));
        }

        public void dropOther(@NotNull Block block, @NotNull Block otherBlock) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genOptionalBlockDrop);
            this.add(block, func.apply(otherBlock));
        }

        public void dropBanner(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, x$0 -> super.createBannerDrop(x$0));
            this.add(block, func.apply(block));
        }

        public void dropOtherBanner(@NotNull Block block, @NotNull Block otherBlock) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, x$0 -> super.createBannerDrop(x$0));
            this.add(block, func.apply(otherBlock));
        }

        public void dropNothing(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, BlockProvider::genBlankBlockDrop);
            this.add(block, func.apply(block));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)block).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }

        protected static LootTable.Builder genBlankBlockDrop(Block block) {
            return LootTable.lootTable();
        }
    }
}

