/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.spell.effect;

import com.hollingsworth.arsnouveau.api.event.DelayedSpellEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketClientDelayEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACNames;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EffectPreciseDelay
extends AbstractEffect {
    public static EffectPreciseDelay INSTANCE = new EffectPreciseDelay();

    private EffectPreciseDelay() {
        super(ArsControle.prefix(ACNames.GLYPH_PRECISE_DELAY), "Precise Delay");
    }

    public String getBookDescription() {
        return "Delays the remainder of the spell by (2 ^ Extend Time Augments) ticks.";
    }

    public void sendPacket(Level world, HitResult rayTraceResult, @Nullable LivingEntity shooter, SpellContext spellContext, SpellStats spellStats, BlockHitResult blockResult, Entity hitEntity, SpellResolver spellResolver) {
        if (spellContext.getCurrentIndex() >= spellContext.getSpell().size()) {
            return;
        }
        int duration = 1 << spellStats.getBuffCount((AbstractAugment)AugmentExtendTime.INSTANCE);
        DelayedSpellEvent delayEvent = new DelayedSpellEvent(spellContext.getDelayedSpellEvent() == null ? duration : duration + 1, rayTraceResult, world, spellResolver);
        spellContext.delay(delayEvent);
        EventQueue.getServerInstance().addEvent((ITimedEvent)delayEvent);
        Networking.sendToNearbyClient((Level)world, (BlockPos)BlockPos.containing((Position)this.safelyGetHitPos(rayTraceResult)), (CustomPacketPayload)new PacketClientDelayEffect(duration, shooter, spellContext.getSpell(), spellContext, blockResult, hitEntity));
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.sendPacket(world, (HitResult)rayTraceResult, shooter, spellContext, spellStats, rayTraceResult, null, resolver);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.sendPacket(world, (HitResult)rayTraceResult, shooter, spellContext, spellStats, null, rayTraceResult.getEntity(), resolver);
    }

    protected int getDefaultManaCost() {
        return 0;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentExtendTime.INSTANCE});
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        super.addDefaultAugmentLimits(defaults);
        defaults.put(AugmentExtendTime.INSTANCE.getRegistryName(), 20);
    }

    protected void addAugmentCostOverrides(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentExtendTime.INSTANCE.getRegistryName(), 0);
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentExtendTime.INSTANCE, "Doubles the delay");
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

