/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class RenderQueue {
    private static final Deque<RenderTask> QUEUE = new ArrayDeque<RenderTask>();
    private static long LAST_TIME = -1L;

    public static void enqueue(RenderTask task) {
        if (task.until < LAST_TIME) {
            return;
        }
        QUEUE.addLast(task);
    }

    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        if (QUEUE.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        LAST_TIME = level.getGameTime();
        Iterator<RenderTask> iter = QUEUE.iterator();
        while (iter.hasNext()) {
            RenderTask task = iter.next();
            if (task.until >= LAST_TIME) continue;
            iter.remove();
        }
    }

    @SubscribeEvent
    public static void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        QUEUE.clear();
        LAST_TIME = -1L;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRender(RenderLevelStageEvent event) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level == null || player == null) {
            return;
        }
        for (RenderTask task : QUEUE) {
            task.fn.accept(event);
        }
    }

    public record RenderTask(Consumer<RenderLevelStageEvent> fn, long until) {
        public static RenderTask until(Consumer<RenderLevelStageEvent> fn, long until) {
            return new RenderTask(fn, until);
        }

        @Nullable
        public static RenderTask ofDuration(Consumer<RenderLevelStageEvent> fn, long length) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null) {
                return null;
            }
            return RenderTask.until(fn, level.getGameTime() + length);
        }
    }
}

