/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.util;

import com.google.common.collect.ImmutableSet;
import dev.qther.ars_controle.util.XYMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XYZMap<V>
extends XYMap<V> {
    private static final ImmutableSet<String> KEYS = ImmutableSet.of((Object)"x", (Object)"y", (Object)"z");
    private V z;

    XYZMap(V x, V y, V z) {
        super(x, y);
        this.z = z;
    }

    public static <V> XYZMap<V> of(V x, V y, V z) {
        return new XYZMap<V>(x, y, z);
    }

    public static XYZMap<Double> of(Vec3 vec) {
        return new XYZMap<Double>(vec.x, vec.y, vec.z);
    }

    public static XYZMap<Integer> of(BlockPos pos) {
        return new XYZMap<Integer>(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && (key.equals("x") || key.equals("y") || key.equals("z"));
    }

    @Override
    public V get(Object key) {
        String s;
        if (key instanceof String && (s = (String)key).equals("z")) {
            return this.z;
        }
        return super.get(key);
    }

    @Override
    @Nullable
    public V put(String key, V value) {
        switch (key) {
            case "x": {
                this.x = value;
                break;
            }
            case "y": {
                this.y = value;
                break;
            }
            case "z": {
                this.z = value;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return KEYS;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return List.of(this.x, this.y, this.z);
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, V>> entrySet() {
        return Set.of(new XYMap.XEntry(this), new XYMap.YEntry(this), new ZEntry(this));
    }

    public V getZ() {
        return this.z;
    }

    public void setZ(V z) {
        this.z = z;
    }

    public static class ZEntry<V>
    implements Map.Entry<String, V> {
        XYZMap<V> map;

        public ZEntry(XYZMap<V> map) {
            this.map = map;
        }

        @Override
        public String getKey() {
            return "z";
        }

        @Override
        public V getValue() {
            return this.map.getZ();
        }

        @Override
        public V setValue(V value) {
            this.map.setZ(value);
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ZEntry)) return false;
            ZEntry other = (ZEntry)o;
            if (!other.map.equals(this.map)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.map.hashCode() + 2;
        }
    }
}

