/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.octolib.modules.particles.trail;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.DefaultTrailBuffer;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailBuffer;
import it.hurts.octostudios.octolib.util.ColorUtils;
import it.hurts.octostudios.octolib.util.TesselatorUtils;
import it.hurts.octostudios.octolib.util.VectorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public interface TrailProvider
extends RenderProvider<TrailProvider, TrailBuffer> {
    @Override
    default public TrailBuffer createBuffer() {
        return new DefaultTrailBuffer(this.getTrailMaxLength());
    }

    @Override
    default public boolean shouldRender(TrailBuffer buffer) {
        return this.isTrailAlive() || !this.disappearAfterDeath() && buffer.size() != 0;
    }

    @Override
    default public Vec3 getRenderPosition(float partialTick) {
        return this.getTrailPosition(partialTick);
    }

    public Vec3 getTrailPosition(float var1);

    @Override
    @Deprecated
    default public double getRenderDistance() {
        return this.getTrailRenderDistance();
    }

    default public double getTrailRenderDistance() {
        return 64.0;
    }

    @Override
    @Deprecated
    default public int getUpdateFrequency() {
        return this.getTrailUpdateFrequency();
    }

    public int getTrailUpdateFrequency();

    public boolean isTrailAlive();

    default public boolean isTrailGrowing() {
        return true;
    }

    default public boolean disappearAfterDeath() {
        return false;
    }

    public int getTrailMaxLength();

    public int getTrailFadeInColor();

    public int getTrailFadeOutColor();

    public double getTrailScale();

    default public int getTrailInterpolationPoints() {
        return 1;
    }

    default public List<Vec3> getTrailRenderPositions(List<Vec3> points, float pTicks) {
        return points;
    }

    @Override
    @Deprecated
    default public void render(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        this.renderTrail(pTicks, poseStack, bufferSourceList);
    }

    default public void renderTrail(float pTicks, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        ClientLevel world = Minecraft.getInstance().level;
        Vec3 matrixTranslation = this.getRenderPosition(pTicks);
        if (world == null) {
            return;
        }
        long time = world.getGameTime();
        int segments = this.getTrailMaxLength();
        if (segments <= 0 || this.getTrailUpdateFrequency() <= 0) {
            return;
        }
        ArrayList<Vec3> partialPoses = new ArrayList<Vec3>();
        float partial = (float)((int)(time % (long)this.getTrailUpdateFrequency())) + pTicks;
        TrailBuffer buffer = (TrailBuffer)OctoRenderManager.getOrCreateBuffer(this);
        List<Vec3> points = new ArrayList<Vec3>();
        if (this.isTrailAlive()) {
            points.add(new Vec3(0.0, 0.0, 0.0));
        }
        for (Vec3 vec3 : buffer) {
            points.add(vec3.subtract(matrixTranslation));
        }
        if ((points = this.getTrailRenderPositions(points, pTicks)).size() > 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                float p;
                Vec3 p0 = i == 0 ? points.getFirst() : points.get(i - 1);
                Vec3 p1 = points.get(i);
                Vec3 p2 = points.get(i + 1);
                Vec3 p3 = i == points.size() - 2 ? points.getLast() : points.get(i + 2);
                partialPoses.add(p1);
                for (float f = p = (float)(this.getTrailInterpolationPoints() + 1); f < 1.0f; f += 1.0f / p) {
                    partialPoses.add(VectorUtils.catmullromVec(f, p0, p1, p2, p3));
                }
            }
            partialPoses.add(points.getLast());
        } else {
            partialPoses.addAll(points);
        }
        if (points.size() > 1 && this.getTrailMaxLength() + 1 == points.size()) {
            int i = partialPoses.size() - 1;
            partialPoses.set(i, ((Vec3)partialPoses.get(i)).add(((Vec3)partialPoses.get(i - 1)).subtract((Vec3)partialPoses.get(i)).scale((double)partial / (double)this.getTrailUpdateFrequency() * (double)this.getTrailInterpolationPoints())));
        }
        this.draw3dTrail(partialPoses, poseStack, bufferSourceList);
    }

    default public void draw3dTrail(List<Vec3> partialPoses, PoseStack poseStack, MultiBufferSource bufferSourceList) {
        Vec3[][] crossVecs = new Vec3[partialPoses.size()][3];
        for (int i = 1; i < partialPoses.size(); ++i) {
            Vec3 pos1 = partialPoses.get(i - 1);
            Vec3 pos2 = partialPoses.get(i);
            Vec3 vec1 = pos2.subtract(pos1);
            Vec3 vec1n = vec1.normalize();
            Vec3 notScaled = Math.abs(vec1n.x) + Math.abs(vec1n.z) < 0.05 ? vec1.add(0.05, 0.0, 0.0).cross(VectorUtils.Y_VEC) : vec1.cross(VectorUtils.Y_VEC);
            double len = 1.0f - (float)(i - 1) / (float)partialPoses.size();
            crossVecs[i - 1][0] = notScaled.normalize().scale(this.getTrailScale() * len);
            Vec3 axis = partialPoses.get(i - 1).subtract(partialPoses.get(i));
            crossVecs[i - 1][1] = VectorUtils.rotate(crossVecs[i - 1][0], axis, 93.0).normalize().scale(crossVecs[i - 1][0].length());
            crossVecs[i - 1][2] = VectorUtils.rotate(crossVecs[i - 1][0], axis, -93.0).normalize().scale(crossVecs[i - 1][0].length());
        }
        Color color1 = new Color(this.getTrailFadeInColor(), true);
        Color color2 = new Color(this.getTrailFadeOutColor(), true);
        poseStack.pushPose();
        Matrix4f matrix4f = poseStack.last().pose();
        for (int i = 0; i < partialPoses.size() && crossVecs[i][0] != null; ++i) {
            Vec3 pos2;
            Color c1 = ColorUtils.blend(color1, color2, (float)i / (float)(partialPoses.size() - 1));
            Color c2 = ColorUtils.blend(color1, color2, ((float)i + 1.0f) / (float)(partialPoses.size() - 1));
            Vec3 pos_i = partialPoses.get(i);
            Vec3 pos11 = pos_i.add(crossVecs[i][0]);
            Vec3 pos12 = pos_i.add(crossVecs[i][1]);
            Vec3 pos13 = pos_i.add(crossVecs[i][2]);
            VertexConsumer tes = bufferSourceList.getBuffer(TesselatorUtils.TRAIL_RENDER_TYPE);
            if (i == 0 && partialPoses.size() > 1) {
                pos2 = pos_i.add(pos_i.subtract(partialPoses.get(1)).normalize().scale(crossVecs[i][0].length()));
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.x, (float)pos12.y, (float)pos12.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos11.x, (float)pos11.y, (float)pos11.z, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.x, (float)pos13.y, (float)pos13.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos12.x, (float)pos12.y, (float)pos12.z, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.x, (float)pos11.y, (float)pos11.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos13.x, (float)pos13.y, (float)pos13.z, c1, c2);
            }
            if (i == crossVecs.length - 1 || crossVecs[i + 1][0] == null) {
                pos2 = partialPoses.get(i + 1);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.x, (float)pos11.y, (float)pos11.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos12.x, (float)pos12.y, (float)pos12.z, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.x, (float)pos12.y, (float)pos12.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos13.x, (float)pos13.y, (float)pos13.z, c1, c2);
                TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.x, (float)pos13.y, (float)pos13.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos2.x, (float)pos2.y, (float)pos2.z, (float)pos11.x, (float)pos11.y, (float)pos11.z, c1, c2);
                continue;
            }
            Vec3 pos21 = partialPoses.get(i + 1).add(crossVecs[i + 1][0]);
            Vec3 pos22 = partialPoses.get(i + 1).add(crossVecs[i + 1][1]);
            Vec3 pos23 = partialPoses.get(i + 1).add(crossVecs[i + 1][2]);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos11.x, (float)pos11.y, (float)pos11.z, (float)pos21.x, (float)pos21.y, (float)pos21.z, (float)pos22.x, (float)pos22.y, (float)pos22.z, (float)pos12.x, (float)pos12.y, (float)pos12.z, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos12.x, (float)pos12.y, (float)pos12.z, (float)pos22.x, (float)pos22.y, (float)pos22.z, (float)pos23.x, (float)pos23.y, (float)pos23.z, (float)pos13.x, (float)pos13.y, (float)pos13.z, c1, c2);
            TesselatorUtils.drawQuadGradient(tes, matrix4f, (float)pos13.x, (float)pos13.y, (float)pos13.z, (float)pos23.x, (float)pos23.y, (float)pos23.z, (float)pos21.x, (float)pos21.y, (float)pos21.z, (float)pos11.x, (float)pos11.y, (float)pos11.z, c1, c2);
        }
        poseStack.popPose();
    }
}

