/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.registration.IRoomRegistrar;
import dev.compactmods.machines.i18n.MachineTranslations;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.Logger;

public class CMRebindSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"rebind").requires(cs -> cs.hasPermission(2));
        subRoot.then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"bindTo", (ArgumentType)StringArgumentType.string()).executes(CMRebindSubcommand::doRebind)));
        return subRoot;
    }

    private static int doRebind(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Logger LOGS = LoggingUtil.modLog();
        IRoomRegistrar roomProvider = CompactMachines.roomRegistrar();
        BlockPos rebindingMachine = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos");
        String roomCode = StringArgumentType.getString(ctx, (String)"bindTo");
        BlockEntity blockEntity = level.getBlockEntity(rebindingMachine);
        if (!(blockEntity instanceof BoundCompactMachineBlockEntity)) {
            LOGS.error("Refusing to rebind block at {}; block has invalid machine data.", (Object)rebindingMachine);
            source.sendFailure(MachineTranslations.NOT_A_MACHINE_BLOCK.apply(rebindingMachine));
            return -1;
        }
        BoundCompactMachineBlockEntity machine = (BoundCompactMachineBlockEntity)blockEntity;
        roomProvider.get(roomCode).ifPresentOrElse(targetRoom -> {
            LOGS.info("Binding machine at {} to room {}", (Object)rebindingMachine, (Object)roomCode);
            machine.setConnectedRoom(roomCode);
        }, () -> LOGS.error("Cannot rebind to room {}; not registered.", (Object)roomCode));
        return 0;
    }
}

