/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room;

import com.mojang.serialization.Codec;
import dev.compactmods.machines.api.room.data.CMRoomDataLocations;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.data.CMDataFile;
import dev.compactmods.machines.data.CodecHolder;
import dev.compactmods.machines.room.graph.node.RoomRegistrationNode;
import dev.compactmods.machines.util.MathUtil;
import dev.compactmods.spatial.aabb.AABBAligner;
import it.unimi.dsi.fastutil.objects.Object2ReferenceArrayMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

class RoomRegistrarData
implements CodecHolder<RoomRegistrarData>,
CMDataFile {
    public static final Codec<RoomRegistrarData> CODEC = RoomRegistrationNode.CODEC.listOf().fieldOf("rooms").xmap(RoomRegistrarData::new, x -> List.copyOf(x.registrationNodes.values())).codec();
    private final MinecraftServer server;
    private final Map<String, RoomRegistrationNode> registrationNodes;

    public RoomRegistrarData(MinecraftServer server) {
        this.server = server;
        this.registrationNodes = new Object2ReferenceArrayMap();
    }

    private RoomRegistrarData(List<RoomRegistrationNode> regNodes) {
        this(ServerLifecycleHooks.getCurrentServer());
        regNodes.forEach(this::registerDirty);
    }

    public AABB getNextBoundaries(RoomTemplate template) {
        Vec3i region = MathUtil.getRegionPositionByIndex(this.registrationNodes.size());
        Vec3 floor = MathUtil.getCenterWithY(region, 0);
        return AABBAligner.floor((AABB)template.getZeroBoundaries().move(floor), (double)0.0);
    }

    public boolean isRegistered(String room) {
        return this.registrationNodes.containsKey(room);
    }

    public Optional<RoomRegistrationNode> get(String room) {
        RoomRegistrationNode regNode = this.registrationNodes.get(room);
        return Optional.ofNullable(regNode);
    }

    public void put(RoomRegistrationNode node) {
        this.registrationNodes.put(node.code(), node);
    }

    public long count() {
        return this.registrationNodes.size();
    }

    public Stream<String> allRoomCodes() {
        return this.registrationNodes.keySet().stream();
    }

    private void registerDirty(RoomRegistrationNode node) {
        this.registrationNodes.putIfAbsent(node.code(), node);
    }

    @Override
    public Path getDataLocation(MinecraftServer server) {
        return (Path)CMRoomDataLocations.DATA_ROOT.apply(server);
    }

    @Override
    public Codec<RoomRegistrarData> codec() {
        return CODEC;
    }

    public Stream<RoomRegistrationNode> allRoomData() {
        return this.registrationNodes.values().stream();
    }
}

