/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.server;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.data.Saveable;
import dev.compactmods.machines.api.dimension.CompactDimension;
import dev.compactmods.machines.room.upgrade.RoomUpgradeHelper;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.jetbrains.annotations.Nullable;

@Mod(value="compactmachines")
public class CompactMachinesServer {
    @Nullable
    private static MinecraftServer CURRENT_SERVER;
    public static TicketController CHUNK_TICKET_CONTROLLER;

    public CompactMachinesServer(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CompactMachinesServer::serverAboutToStart);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CompactMachinesServer::serverStarting);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CompactMachinesServer::serverStopping);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, CompactMachinesServer::levelSaved);
        modBus.addListener(CompactMachinesServer::registerTicketController);
    }

    private static void registerTicketController(RegisterTicketControllersEvent event) {
        event.register(CHUNK_TICKET_CONTROLLER);
    }

    private static void serverAboutToStart(ServerAboutToStartEvent evt) {
        CURRENT_SERVER = evt.getServer();
        CompactMachines.reloadServices((MinecraftServer)CURRENT_SERVER);
    }

    private static void serverStarting(ServerStartingEvent evt) {
        CompactMachines.reloadServices((MinecraftServer)evt.getServer());
    }

    public static void saveAll() {
        if (CURRENT_SERVER != null) {
            Stream.of(CompactMachines.roomRegistrar(), CompactMachines.roomDataAccessor(), CompactMachines.playerHistoryApi(), CompactMachines.spawnManagers(), CompactMachines.upgradeDataAccessor()).filter(Objects::nonNull).forEach(Saveable::save);
        }
    }

    public static void serverStopping(ServerStoppingEvent ignored) {
        CompactMachinesServer.saveAll();
    }

    public static void levelSaved(LevelEvent.Save level) {
        Level l;
        LevelAccessor levelAccessor = level.getLevel();
        if (levelAccessor instanceof Level && CompactDimension.isLevelCompact((Level)(l = (Level)levelAccessor))) {
            CompactMachinesServer.saveAll();
        }
    }

    public static MinecraftServer currentServer() {
        return CURRENT_SERVER;
    }

    static {
        CHUNK_TICKET_CONTROLLER = new TicketController(CompactMachines.modRL((String)"chunkloader_upgrade"), (serverLevel, ticketHelper) -> RoomUpgradeHelper.verifyChunkloaderUpgrades(ticketHelper));
    }
}

