/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.server.service;

import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.upgrade.IRoomUpgradeAccessor;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeInstance;
import dev.compactmods.machines.api.room.upgrade.inventory.RoomUpgradeInventory;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;

public class CMServerRoomUpgradeAccessor
implements IRoomUpgradeAccessor {
    private final Map<UUID, RoomUpgradeInstance> INSTANCES = new Object2ObjectOpenHashMap();
    private final RoomInstance roomInstance;

    public CMServerRoomUpgradeAccessor(RoomInstance roomInstance) {
        this.roomInstance = roomInstance;
        ((RoomUpgradeInventory)roomInstance.getData(CMDataAttachments.UPGRADE_ITEMS)).items().filter(is -> is.has((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID)).forEach(is -> {
            UUID id = (UUID)is.get((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID);
            RoomUpgradeInstance instance = this.getOrCreateInstance(id);
            this.INSTANCES.put(id, instance);
        });
    }

    public Stream<RoomUpgradeInstance> all() {
        return this.INSTANCES.values().stream();
    }

    public Optional<RoomUpgradeInstance> getExistingInstance(UUID id) {
        return this.INSTANCES.containsKey(id) ? Optional.of(this.INSTANCES.get(id)) : Optional.empty();
    }

    public RoomUpgradeInstance getOrCreateInstance(UUID id) {
        return this.getExistingInstance(id).orElseGet(() -> this.createInstance(id));
    }

    public void remove(UUID uuid) {
        this.INSTANCES.remove(uuid);
    }

    public void clearCache() {
        this.INSTANCES.clear();
    }

    private RoomUpgradeInstance createInstance(UUID id) {
        Optional<ItemStack> upgradeItem = ((RoomUpgradeInventory)this.roomInstance.getData(CMDataAttachments.UPGRADE_ITEMS)).items().filter(stack -> stack.has((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID)).filter(stack -> {
            UUID instanceID = (UUID)stack.get((Supplier)CMDataComponents.UPGRADE_INSTANCE_ID);
            if (instanceID == null) {
                return false;
            }
            return instanceID.equals(id);
        }).findFirst();
        RoomUpgradeInstance instance = new RoomUpgradeInstance(this.roomInstance, id, upgradeItem.orElse(ItemStack.EMPTY));
        this.INSTANCES.put(id, instance);
        return instance;
    }
}

