/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util.item;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public record ItemHandlerScan(Set<Integer> stacking, Set<Integer> empty) {
    public static ItemHandlerScan scanInventory(IItemHandler inventory, ItemStack stack) {
        ImmutableSet.Builder stackingBuilder = ImmutableSet.builder();
        ImmutableSet.Builder emptyBuilder = ImmutableSet.builder();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean canActuallyInsert;
            ItemStack inSlot = inventory.getStackInSlot(i);
            if (inSlot.isEmpty()) {
                emptyBuilder.add((Object)i);
                continue;
            }
            if (!inSlot.isStackable() || !ItemStack.isSameItemSameComponents((ItemStack)inSlot, (ItemStack)stack) || !(canActuallyInsert = inventory.insertItem(i, stack.copyWithCount(1), true).isEmpty())) continue;
            stackingBuilder.add((Object)i);
        }
        return new ItemHandlerScan((Set<Integer>)stackingBuilder.build(), (Set<Integer>)emptyBuilder.build());
    }

    public boolean hasSpaceAvailable() {
        return !this.stacking.isEmpty() || !this.empty.isEmpty();
    }
}

