/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.shiny.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import cy.jdkdigital.shiny.client.renderer.entity.layers.ChestedHorseShinyLayer;
import cy.jdkdigital.shiny.init.ModEntities;
import java.util.Map;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import org.jetbrains.annotations.NotNull;

public class ShinyChestedHorseRenderer<T extends AbstractChestedHorse>
extends AbstractHorseRenderer<T, ChestedHorseModel<T>> {
    private static final Map<EntityType<?>, ResourceLocation> MAP = ImmutableMap.of((Object)((EntityType)ModEntities.DONKEY.get()), (Object)ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/donkey.png"), (Object)((EntityType)ModEntities.MULE.get()), (Object)ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/mule.png"));

    public ShinyChestedHorseRenderer(EntityRendererProvider.Context context, float size, ModelLayerLocation model) {
        super(context, (HorseModel)new ChestedHorseModel(context.bakeLayer(model)), size);
        this.addLayer(new ChestedHorseShinyLayer(this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return MAP.get(entity.getType());
    }
}

