/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class ShapedTransferComponentsRecipe
extends ShapedRecipe {
    private final ItemStack result;
    private final int transferSlot;

    public ShapedTransferComponentsRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, int transferSlot) {
        super(group, category, pattern, result, showNotification);
        this.result = result;
        this.transferSlot = transferSlot;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        ItemStack stack = inventory.getItem(this.transferSlot);
        ItemStack result = this.getResultItem(lookup).copy();
        result.applyComponents(stack.getComponentsPatch());
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_TRANSFER_COMPONENTS.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTransferComponentsRecipe> {
        public static final MapCodec<ShapedTransferComponentsRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification), (App)Codec.INT.fieldOf("transfer_slot").forGetter(recipe -> recipe.transferSlot)).apply((Applicative)builder, ShapedTransferComponentsRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedTransferComponentsRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedTransferComponentsRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedTransferComponentsRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedTransferComponentsRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean showNotification = buffer.readBoolean();
            int transferSlot = buffer.readVarInt();
            return new ShapedTransferComponentsRecipe(group, category, pattern, result, showNotification, transferSlot);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedTransferComponentsRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification());
            buffer.writeVarInt(recipe.transferSlot);
        }
    }
}

