/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.iface.ICustomBow;
import java.util.function.Function;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.Level;

public class BaseCrossbowItem
extends CrossbowItem
implements ICustomBow {
    public BaseCrossbowItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.apply(new Item.Properties()));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int i = (int)((float)(this.getUseDuration(stack, entity) - timeLeft) * this.getDrawSpeedMulti(stack));
        float f = BaseCrossbowItem.getPowerForTime((int)i, (ItemStack)stack, (LivingEntity)entity);
        if (f >= 1.0f && !BaseCrossbowItem.isCharged((ItemStack)stack) && BaseCrossbowItem.tryLoadProjectiles((LivingEntity)entity, (ItemStack)stack)) {
            CrossbowItem.ChargingSounds sounds = this.getChargingSounds(stack);
            sounds.end().ifPresent(sound -> level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)sound.value(), entity.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
        }
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (!level.isClientSide) {
            CrossbowItem.ChargingSounds sounds = this.getChargingSounds(stack);
            float f = (float)((int)((float)(this.getUseDuration(stack, entity) - timeLeft) * this.getDrawSpeedMulti(stack))) / (float)BaseCrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                sounds.start().ifPresent(p_352849_ -> level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)p_352849_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if (f >= 0.5f && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                sounds.mid().ifPresent(p_352855_ -> level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)p_352855_.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.setBaseDamage(arrow.getBaseDamage() + (double)this.getBonusDamage(weaponStack));
        return arrow;
    }

    @Override
    public boolean hasFOVChange() {
        return false;
    }

    public static ItemPropertyFunction getPullPropertyGetter() {
        return (stack, level, entity, _unused) -> {
            if (entity == null) {
                return 0.0f;
            }
            return BaseCrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) * ((ICustomBow)stack.getItem()).getDrawSpeedMulti(stack) / (float)BaseCrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity);
        };
    }

    public static ItemPropertyFunction getPullingPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f;
    }

    public static ItemPropertyFunction getChargedPropertyGetter() {
        return (stack, level, entity, _unused) -> entity != null && BaseCrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f;
    }

    public static ItemPropertyFunction getFireworkPropertyGetter() {
        return (stack, level, entity, _unused) -> {
            ChargedProjectiles projectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
            return projectiles != null && projectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
        };
    }
}

