/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.lib.ModTags;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BaseSickleItem
extends DiggerItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseSickleItem(Tier tier, int range) {
        this(tier, range, p -> p);
    }

    public BaseSickleItem(Tier tier, int range, Function<Item.Properties, Item.Properties> properties) {
        super(tier, ModTags.MINEABLE_WITH_SICKLE, properties.apply(new Item.Properties().attributes(BaseSickleItem.createAttributes((Tier)tier, (float)4.0f, (float)-3.0f))));
        this.attackDamage = 4.0f;
        this.attackSpeed = -3.0f;
        this.range = range;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return state.is(ModTags.MINEABLE_WITH_SICKLE) ? this.getTier().getSpeed() / 2.0f : super.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (level.isClientSide()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.harvestAOEBlocks(stack, level, pos, player);
        }
        return false;
    }

    public float getAttackDamage() {
        return this.attackDamage + this.getTier().getAttackDamageBonus();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private void harvestAOEBlocks(ItemStack stack, Level level, BlockPos pos, Player player) {
        BlockState state = level.getBlockState(pos);
        if (this.range > 0 && this.isCorrectToolForDrops(stack, state)) {
            float hardness = state.getDestroySpeed((BlockGetter)level, pos);
            BlockPos.betweenClosed((BlockPos)pos.offset(-this.range, -this.range, -this.range), (BlockPos)pos.offset(this.range, this.range, this.range)).forEach(aoePos -> {
                if (stack.isEmpty()) {
                    return;
                }
                if (aoePos != pos) {
                    BlockState aoeState = level.getBlockState(aoePos);
                    if (!this.isCorrectToolForDrops(stack, aoeState)) {
                        return;
                    }
                    float aoeHardness = aoeState.getDestroySpeed((BlockGetter)level, aoePos);
                    if (aoeHardness > hardness + 5.0f) {
                        return;
                    }
                    boolean harvested = BlockHelper.harvestAOEBlock(stack, level, (ServerPlayer)player, aoePos.immutable());
                    if (harvested && !player.getAbilities().instabuild && aoeHardness <= 0.0f && Math.random() < 0.33) {
                        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    }
                }
            });
        }
    }
}

