/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.common.advancements;

import betteradvancements.common.advancements.BetterDisplayInfo;
import betteradvancements.common.platform.Services;
import betteradvancements.common.reference.Constants;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class BetterDisplayInfoRegistry {
    private final Map<ResourceLocation, BetterDisplayInfo> registry = new HashMap<ResourceLocation, BetterDisplayInfo>();

    public BetterDisplayInfoRegistry(AdvancementNode advancementNode) {
    }

    public BetterDisplayInfo get(AdvancementHolder advancementHolder) {
        return this.registry.getOrDefault(advancementHolder.id(), new BetterDisplayInfo(advancementHolder));
    }

    private void load(ResourceLocation location, ServerLevel serverLevel) {
        Services.PLATFORM.getAdvancementVisitor().findAdvancements(location, serverLevel, null, (root, file) -> {
            String relative;
            try {
                relative = root.relativize((Path)file).toString();
            }
            catch (Exception e) {
                relative = "";
            }
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)name);
            if (!this.registry.containsKey(key)) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(file);
                    JsonObject advancement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    JsonObject betterDisplay = advancement.getAsJsonObject("better_display");
                    this.registry.put(key, new BetterDisplayInfo(key, betterDisplay));
                }
                catch (JsonParseException jsonparseexception) {
                    Constants.log.error("Parsing error loading built-in advancement " + String.valueOf(key), (Throwable)jsonparseexception);
                    Boolean bl = false;
                    return bl;
                }
                catch (IOException ioexception) {
                    Constants.log.error("Couldn't read advancement " + String.valueOf(key) + " from " + String.valueOf(file), (Throwable)ioexception);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, true, true);
    }
}

