/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.fluids;

import com.glodblock.github.modularbees.common.MBSingletons;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public abstract class FluidDragonBreath
extends BaseFlowingFluid {
    public static final FluidType TYPE = new FluidType(FluidType.Properties.create().canExtinguish(true).supportsBoating(true).fallDistanceModifier(0.0f).temperature(1000).sound(SoundActions.BUCKET_FILL, SoundEvents.BOTTLE_FILL_DRAGONBREATH).lightLevel(8));

    protected FluidDragonBreath() {
        super(new BaseFlowingFluid.Properties(() -> TYPE, FluidDragonBreath::getFluid, FluidDragonBreath::getFlowFluid).slopeFindDistance(8).explosionResistance(100.0f).bucket(() -> MBSingletons.DRAGON_BREATH_BUCKET).block(() -> MBSingletons.DRAGON_BREATH));
    }

    public static BaseFlowingFluid getFluid() {
        return Still.INSTANCE;
    }

    public static BaseFlowingFluid getFlowFluid() {
        return Flow.INSTANCE;
    }

    @NotNull
    public Fluid getFlowing() {
        return Flow.INSTANCE;
    }

    @NotNull
    public Fluid getSource() {
        return Still.INSTANCE;
    }

    private static class Still
    extends FluidDragonBreath {
        static FluidDragonBreath INSTANCE = new Still();

        private Still() {
        }

        public boolean isSource(@NotNull FluidState state) {
            return true;
        }

        public int getAmount(@NotNull FluidState state) {
            return 8;
        }
    }

    private static class Flow
    extends FluidDragonBreath {
        static FluidDragonBreath INSTANCE = new Flow();

        private Flow() {
        }

        protected void createFluidStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(@NotNull FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(@NotNull FluidState state) {
            return false;
        }
    }
}

