/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.inventory;

import com.glodblock.github.modularbees.common.inventory.IO;
import java.util.function.Predicate;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class MBFluidInventory
extends FluidTank {
    protected IO mode = IO.ALL;
    protected final BlockEntity host;

    public MBFluidInventory(BlockEntity host, int capacity) {
        super(capacity);
        this.host = host;
    }

    public MBFluidInventory(BlockEntity host, int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
        this.host = host;
    }

    public MBFluidInventory inputOnly() {
        this.mode = IO.IN;
        return this;
    }

    public MBFluidInventory outputOnly() {
        this.mode = IO.OUT;
        return this;
    }

    public int forceFill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (this.mode.canInsert()) {
            return super.fill(resource, action);
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (this.mode.canExtract()) {
            return super.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        if (this.mode.canExtract()) {
            return super.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    protected void onContentsChanged() {
        if (this.host != null) {
            this.host.setChanged();
        }
    }

    public void setFluid(@NotNull FluidStack stack) {
        super.setFluid(stack);
        this.host.setChanged();
    }
}

