/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.util;

import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredHolder;

public class StackCacheMap {
    private final Object2IntMap<ResourceLocation> comb = new Object2IntOpenHashMap();
    private final Object2IntMap<ItemStack> nbtItem = new Object2IntOpenCustomHashMap(GameUtil.ITEM_HASH);
    private final Map<Item, Integer> item = new IdentityHashMap<Item, Integer>();
    private final RandomSource random;

    public StackCacheMap(RandomSource random) {
        this.random = random;
    }

    public void add(ItemStack stack) {
        ResourceLocation type;
        if (stack.isEmpty()) {
            return;
        }
        int amt = stack.getCount();
        if (stack.getItem() instanceof Honeycomb && (type = (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE)) != null) {
            this.comb.computeInt((Object)type, (k, v) -> v == null ? amt : v + amt);
            return;
        }
        if (stack.isComponentsPatchEmpty()) {
            this.item.compute(stack.getItem(), (k, v) -> v == null ? amt : v + amt);
            return;
        }
        this.nbtItem.compute((Object)stack.copyWithCount(1), (k, v) -> v == null ? amt : v + amt);
    }

    public List<ItemStack> getItems(boolean blockMode, float multiplier) {
        int amt;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        DeferredHolder item = blockMode ? ModItems.CONFIGURABLE_COMB_BLOCK : ModItems.CONFIGURABLE_HONEYCOMB;
        int absoluteMulti = (int)multiplier;
        float partialMultiplier = multiplier - (float)absoluteMulti;
        for (Object2IntMap.Entry entry : this.comb.object2IntEntrySet()) {
            amt = entry.getIntValue();
            ItemStack comb = new ItemStack((Holder)item, amt * absoluteMulti);
            if (this.random.nextFloat() <= partialMultiplier) {
                comb.grow(amt);
            }
            comb.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)entry.getKey()));
            stacks.add(comb);
        }
        for (Object2IntMap.Entry entry : this.nbtItem.object2IntEntrySet()) {
            amt = entry.getIntValue();
            ItemStack stack = ((ItemStack)entry.getKey()).copyWithCount(amt * absoluteMulti);
            if (this.random.nextFloat() <= partialMultiplier) {
                stack.grow(amt);
            }
            stacks.add(stack);
        }
        for (Map.Entry entry : this.item.entrySet()) {
            ItemLike key = (ItemLike)entry.getKey();
            if (blockMode) {
                if (key == ModItems.HONEYCOMB_GHOSTLY.get()) {
                    key = (ItemLike)ModBlocks.COMB_GHOSTLY.get();
                } else if (key == ModItems.HONEYCOMB_MILKY.get()) {
                    key = (ItemLike)ModBlocks.COMB_MILKY.get();
                } else if (key == ModItems.HONEYCOMB_POWDERY.get()) {
                    key = (ItemLike)ModBlocks.COMB_POWDERY.get();
                } else if (key == Items.HONEYCOMB) {
                    key = Blocks.HONEYCOMB_BLOCK;
                }
            }
            int amt2 = (Integer)entry.getValue();
            ItemStack comb = new ItemStack(key, amt2 * absoluteMulti);
            if (this.random.nextFloat() <= partialMultiplier) {
                comb.grow(amt2);
            }
            stacks.add(comb);
        }
        return stacks;
    }
}

