/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliobiomes;

import com.github.minecraftschurlimods.bibliocraft.api.woodtype.RegisterBibliocraftWoodTypesEvent;
import java.util.function.Supplier;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;

public abstract class AbstractMod {
    protected final String modId;

    public AbstractMod(String modId, IEventBus bus) {
        this.modId = modId;
        bus.addListener(this::registerWoodTypes);
    }

    protected abstract void registerWoodTypes(RegisterBibliocraftWoodTypesEvent var1);

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, String texture, WoodType woodType, Supplier<? extends Block> planks, Supplier<BlockFamily> blockFamily) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), woodType, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)planks.get())), ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)texture), blockFamily);
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, WoodType woodType, Supplier<? extends Block> planks, Supplier<BlockFamily> blockFamily) {
        this.woodType(event, name, "block/" + name + "_planks", woodType, planks, blockFamily);
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, String texture, Supplier<? extends Block> planks, Supplier<BlockFamily> blockFamily) {
        this.woodType(event, name, texture, AbstractMod.vanillaWoodType(this.modId + "_" + name), planks, blockFamily);
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, Supplier<? extends Block> planks, Supplier<BlockFamily> blockFamily) {
        this.woodType(event, name, "block/" + name + "_planks", AbstractMod.vanillaWoodType(this.modId + "_" + name), planks, blockFamily);
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, String texture, WoodType woodType, Supplier<? extends Block> planks, Supplier<? extends Block> slab, Supplier<? extends Block> stairs) {
        this.woodType(event, name, texture, woodType, planks, AbstractMod.blockFamily(planks, slab, stairs));
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, WoodType woodType, Supplier<? extends Block> planks, Supplier<? extends Block> slab, Supplier<? extends Block> stairs) {
        this.woodType(event, name, "block/" + name + "_planks", woodType, planks, AbstractMod.blockFamily(planks, slab, stairs));
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, String texture, Supplier<? extends Block> planks, Supplier<? extends Block> slab, Supplier<? extends Block> stairs) {
        this.woodType(event, name, texture, AbstractMod.vanillaWoodType(this.modId + "_" + name), planks, AbstractMod.blockFamily(planks, slab, stairs));
    }

    public void woodType(RegisterBibliocraftWoodTypesEvent event, String name, Supplier<? extends Block> planks, Supplier<? extends Block> slab, Supplier<? extends Block> stairs) {
        this.woodType(event, name, "block/" + name + "_planks", AbstractMod.vanillaWoodType(this.modId + "_" + name), planks, AbstractMod.blockFamily(planks, slab, stairs));
    }

    public static WoodType vanillaWoodType(String name) {
        return new WoodType(name, new BlockSetType(name));
    }

    public static Supplier<BlockFamily> blockFamily(Supplier<? extends Block> planks, Supplier<? extends Block> slab, Supplier<? extends Block> stairs) {
        return () -> new BlockFamily.Builder((Block)planks.get()).slab((Block)slab.get()).stairs((Block)stairs.get()).getFamily();
    }
}

