/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class SurfaceHelper {
    private SurfaceHelper() {
    }

    public static int getSurfaceHeight(ChunkAccess chunk, ColumnPos pos) {
        int maxY = chunk.getMaxBuildHeight() - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(pos.x(), maxY, pos.z());
        if (chunk.getBlockState((BlockPos)blockPos) != Blocks.AIR.defaultBlockState()) {
            return maxY;
        }
        for (int y = maxY; y >= 0; --y) {
            BlockState blockState = chunk.getBlockState((BlockPos)blockPos);
            if (blockState != Blocks.AIR.defaultBlockState()) {
                return y;
            }
            blockPos.move(Direction.DOWN);
        }
        return 1;
    }
}

