/*
 * Decompiled with CFR 0.152.
 */
package mcjty.restrictions.blocks;

import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.restrictions.items.GlassBoots;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class OneWayBlock
extends BaseBlock {
    private static final double SPEED = 0.2;

    public OneWayBlock() {
        super(new BlockBuilder().properties(BlockBehaviour.Properties.of().isRedstoneConductor((state, reader, pos) -> false).isSuffocating((state, reader, pos) -> false).strength(2.0f).noCollission().sound(SoundType.GLASS)).info(new InfoLine[]{TooltipBuilder.key((String)"message.restrictions.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        ItemStack boots;
        Direction direction = (Direction)world.getBlockState(pos).getValue((Property)BlockStateProperties.FACING);
        if (!world.isClientSide) {
            entity.push((double)direction.getStepX() * 0.2, (double)direction.getStepY() * 0.2, (double)direction.getStepZ() * 0.2);
            if (direction == Direction.UP && entity.getDeltaMovement().y > -0.5) {
                entity.fallDistance = 1.0f;
            }
        } else if (entity instanceof Player && ((boots = ((Player)entity).getItemBySlot(EquipmentSlot.FEET)).isEmpty() || !(boots.getItem() instanceof GlassBoots))) {
            entity.push((double)direction.getStepX() * 0.2, (double)direction.getStepY() * 0.2, (double)direction.getStepZ() * 0.2);
            if (direction == Direction.UP && entity.getDeltaMovement().y > -0.5) {
                entity.fallDistance = 1.0f;
            }
        }
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return true;
    }

    public int getLightBlock(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 0;
    }
}

