/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.particle;

import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.LavaParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;

public class PoppingNectarParticle
extends LavaParticle {
    public PoppingNectarParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
        this.lifetime = (int)(10.0 / (world.random.nextDouble() * 0.8 + 0.2));
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.8f;
            this.yd *= (double)0.8f;
            this.zd *= (double)0.8f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public static class PoppingNectarFactory
    implements ParticleProvider<NectarParticleType> {
        protected final SpriteSet sprite;

        public PoppingNectarFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@Nonnull NectarParticleType typeIn, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PoppingNectarParticle dripparticle = new PoppingNectarParticle(world, x, y, z);
            float[] colors = typeIn.getColor();
            if (colors != null) {
                dripparticle.setColor(colors[0], colors[1], colors[2]);
            }
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }
}

