/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.Bee;

public class SaddleBeeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Bee bee) {
        this.trigger(player, trigger -> trigger.test(bee));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, String beeName) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.STRING.fieldOf("bee").forGetter(TriggerInstance::beeName)).apply((Applicative)instance, TriggerInstance::new));

        public static TriggerInstance any() {
            return new TriggerInstance(Optional.empty(), "any");
        }

        public static TriggerInstance create(String beeName) {
            return new TriggerInstance(Optional.empty(), beeName);
        }

        public boolean test(Bee bee) {
            return bee instanceof Saddleable && ((Saddleable)bee).isSaddled();
        }
    }
}

