/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.ExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;

public class ExpansionBox
extends Block
implements EntityBlock {
    public static final BooleanProperty HAS_HONEY = BooleanProperty.create((String)"has_honey");

    public ExpansionBox(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)Direction.NORTH)).setValue(AdvancedBeehive.EXPANDED, (Comparable)((Object)VerticalHive.NONE))).setValue((Property)HAS_HONEY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BeehiveBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BeehiveBlock.FACING, AdvancedBeehive.EXPANDED, HAS_HONEY});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ExpansionBoxBlockEntity(pos, state);
    }

    public void updateState(Level level, BlockPos pos, BlockState state, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        Pair<Pair<BlockPos, Direction>, BlockState> pair2 = pair = ((VerticalHive)((Object)state.getValue(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) ? ExpansionBox.getAdjacentHive(level, pos) : ExpansionBox.getAttachedHive(state, level, pos);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos hivePos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(level, hivePos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(level, pos, state, directionProperty, (Direction)((BlockState)pair.getRight()).getValue((Property)BeehiveBlock.FACING));
                ((AdvancedBeehive)((BlockState)pair.getRight()).getBlock()).updateStateWithDirection(level, hivePos, (BlockState)pair.getRight(), directionProperty);
            } else {
                ((AdvancedBeehive)((BlockState)pair.getRight()).getBlock()).updateState(level, hivePos, (BlockState)pair.getRight(), false);
            }
        } else if (!isRemoved) {
            this.updateStateWithDirection(level, pos, state, VerticalHive.NONE, (Direction)state.getValue((Property)BeehiveBlock.FACING));
        }
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        Pair posAndDirection;
        BlockPos hivePos;
        BlockEntity hiveTileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        ItemStack heldItem = player.getMainHandItem();
        if (level instanceof ServerLevel && heldItem.getItem().equals(Items.STICK) && !((VerticalHive)((Object)state.getValue(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (pair = ExpansionBox.getAttachedHive(state, level, pos)) != null && (hiveTileEntity = level.getBlockEntity(hivePos = (BlockPos)(posAndDirection = (Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveBlockEntityAbstract) {
            ((AdvancedBeehiveBlockEntityAbstract)hiveTileEntity).emptyAllLivingFromHive(player, state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
        }
        super.attack(state, level, pos, player);
    }

    public void updateStateWithDirection(Level level, BlockPos pos, BlockState state, VerticalHive directionProperty, Direction facing) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(AdvancedBeehive.EXPANDED, (Comparable)((Object)directionProperty))).setValue((Property)BeehiveBlock.FACING, (Comparable)facing));
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentHive(Level level, BlockPos pos) {
        for (Direction direction : BlockStateProperties.FACING.getPossibleValues()) {
            BlockPos newPos = pos.relative(direction);
            BlockState blockStateAtPos = level.getBlockState(newPos);
            Block blockAtPos = blockStateAtPos.getBlock();
            if (!(blockAtPos instanceof AdvancedBeehive) || blockAtPos instanceof DragonEggHive) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAttachedHive(BlockState boxState, Level level, BlockPos pos) {
        VerticalHive expandDirection;
        Direction hiveDirection;
        BlockState blockStateAtPos;
        if (boxState.is(ModTags.BOXES_BLOCK) && (blockStateAtPos = level.getBlockState(pos.relative(hiveDirection = (expandDirection = (VerticalHive)((Object)boxState.getValue(AdvancedBeehive.EXPANDED))).getExpandedCardinalDirection((Direction)boxState.getValue((Property)BeehiveBlock.FACING)).getOpposite()))).getBlock() instanceof AdvancedBeehive && !(blockStateAtPos.getBlock() instanceof DragonEggHive)) {
            return Pair.of((Object)Pair.of((Object)pos.relative(hiveDirection), (Object)hiveDirection), (Object)blockStateAtPos);
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            this.updateState(level, pos, state, false);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.isClientSide()) {
            this.updateState(world, pos, state, true);
        }
        return removed;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        Direction dir;
        BlockEntity blockEntity;
        if (!((VerticalHive)((Object)pState.getValue(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (blockEntity = pLevel.getBlockEntity(pPos.relative(dir = ((VerticalHive)((Object)pState.getValue(AdvancedBeehive.EXPANDED))).getExpandedCardinalDirection((Direction)pState.getValue((Property)BeehiveBlock.FACING)).getOpposite()))) instanceof AdvancedBeehiveBlockEntity) {
            AdvancedBeehiveBlockEntity hiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity;
            if (!pLevel.isClientSide()) {
                BlockState hiveState = pLevel.getBlockState(pPos.relative(dir));
                pLevel.sendBlockUpdated(pPos.relative(dir), hiveState, hiveState, 3);
                pPlayer.openMenu((MenuProvider)hiveBlockEntity, pPos.relative(dir));
            }
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }
}

