/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.container.IncubatorContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class IncubatorBlockEntity
extends CapabilityBlockEntity
implements MenuProvider,
UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    public int recipeProgress = 0;
    public boolean isRunning = false;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 3, (BlockEntity)this){

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot == 0 && item.getItem() instanceof BeeCage || slot == 0 && item.is(Tags.Items.EGGS) || slot == 1 && item.getItem() instanceof HoneyTreat;
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get()));
    public EnergyStorage energyHandler = new EnergyStorage(10000);

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), pos, state);
    }

    @Override
    public RecipeHolder<? extends TimedRecipeInterface> getCurrentRecipe() {
        return null;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(RecipeHolder<? extends TimedRecipeInterface> recipe) {
        return Math.max((int)((double)(recipe != null ? ((TimedRecipeInterface)recipe.value()).getProcessingTime() : ((Integer)ProductiveBeesConfig.GENERAL.incubatorProcessingTime.get()).intValue()) * this.getProcessingTimeModifier()), 5);
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity blockEntity) {
        if (blockEntity.isRunning && level instanceof ServerLevel) {
            blockEntity.energyHandler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false);
        }
        if (!blockEntity.inventoryHandler.getStackInSlot(0).isEmpty()) {
            if (blockEntity.isRunning || blockEntity.canProcessInput(blockEntity.inventoryHandler)) {
                blockEntity.setRunning(true);
                int totalTime = blockEntity.getProcessingTime(null);
                if (blockEntity.recipeProgress >= totalTime && blockEntity.completeIncubation(blockEntity.inventoryHandler, level.random)) {
                    blockEntity.recipeProgress = 0;
                    blockEntity.setChanged();
                } else {
                    blockEntity.recipeProgress = Math.min(totalTime, blockEntity.recipeProgress + 1);
                }
            }
        } else {
            blockEntity.recipeProgress = 0;
            blockEntity.setRunning(false);
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler) {
        int energy = this.energyHandler.getEnergyStored();
        ItemStack inItem = invHandler.getStackInSlot(0);
        ItemStack treatItem = invHandler.getStackInSlot(1);
        boolean eggProcessing = inItem.is(Tags.Items.EGGS);
        boolean cageProcessing = inItem.getItem() instanceof BeeCage && BeeCage.isFilled(inItem);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (eggProcessing || cageProcessing) && treatItem.getItem().equals(ModItems.HONEY_TREAT.get()) && (cageProcessing && (treatItem.getCount() >= (Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get() || HoneyTreat.hasGene(treatItem) && !HoneyTreat.hasBeeType(treatItem)) || eggProcessing && !treatItem.isEmpty() && HoneyTreat.hasBeeType(treatItem));
    }

    private boolean completeIncubation(IItemHandlerModifiable invHandler, RandomSource random) {
        if (this.canProcessInput(invHandler)) {
            ItemStack inItem = invHandler.getStackInSlot(0);
            ItemStack catalystItem = invHandler.getStackInSlot(1);
            boolean eggProcessing = inItem.is(Tags.Items.EGGS);
            boolean cageProcessing = inItem.getItem() instanceof BeeCage;
            ItemStack resultItem = ItemStack.EMPTY;
            int shrinkCatalyst = 1;
            int shrinkInput = 1;
            if (cageProcessing) {
                if (HoneyTreat.hasGene(catalystItem)) {
                    Bee entity = BeeCage.getEntityFromStack(inItem, this.level, true);
                    if (entity instanceof Bee) {
                        Bee bee = entity;
                        HoneyTreat.applyGenesToBee(this.level, catalystItem, bee);
                        resultItem = new ItemStack((ItemLike)inItem.getItem());
                        BeeCage.captureEntity(bee, resultItem);
                    }
                } else if (BeeCage.isFilled(inItem)) {
                    CompoundTag nbt = ((CustomData)inItem.get(DataComponents.CUSTOM_DATA)).copyTag();
                    if (nbt.contains("Age")) {
                        nbt.putInt("Age", 0);
                    }
                    resultItem = inItem.copy();
                    resultItem.setCount(1);
                    resultItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
                    shrinkCatalyst = (Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get();
                }
            } else if (eggProcessing) {
                try {
                    List<GeneGroup> genes = HoneyTreat.getGenes(catalystItem);
                    for (GeneGroup geneGroup : genes) {
                        GeneAttribute geneAttribute = geneGroup.attribute();
                        if (!geneAttribute.equals((Object)GeneAttribute.TYPE)) continue;
                        if (random.nextInt(100) <= geneGroup.purity()) {
                            ItemStack egg = BeeCreator.getSpawnEgg(ResourceLocation.parse((String)geneGroup.value()));
                            if (!(egg.getItem() instanceof SpawnEggItem)) continue;
                            resultItem = egg;
                            continue;
                        }
                        inItem.shrink(shrinkInput);
                        catalystItem.shrink(1);
                    }
                }
                catch (Exception e) {
                    ProductiveBees.LOGGER.debug("Failed to create bee spawn egg " + e.getMessage());
                }
            }
            ItemStack outItem = invHandler.getStackInSlot(2);
            if (!resultItem.isEmpty() && (outItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outItem, (ItemStack)resultItem)) && (outItem.isEmpty() || outItem.getCount() + resultItem.getCount() <= outItem.getMaxStackSize())) {
                if (outItem.isEmpty()) {
                    invHandler.setStackInSlot(2, resultItem);
                } else {
                    outItem.grow(resultItem.getCount());
                }
                inItem.shrink(shrinkInput);
                catalystItem.shrink(shrinkCatalyst);
            }
            return true;
        }
        return false;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void setChanged() {
        super.setChanged();
        this.setRunning(false);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        this.recipeProgress = tag.getInt("RecipeProgress");
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("RecipeProgress", this.recipeProgress);
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.INCUBATOR.get()).getDescriptionId());
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new IncubatorContainer(pContainerId, pPlayerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }
}

