/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.container.PoweredCentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.registry.LibItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;

public class PoweredCentrifugeBlockEntity
extends CentrifugeBlockEntity {
    public EnergyStorage energyHandler = new EnergyStorage(10000);

    public PoweredCentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), pos, state);
    }

    public PoweredCentrifugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredCentrifugeBlockEntity blockEntity) {
        CentrifugeBlockEntity.tick(level, pos, state, blockEntity);
        if (((Boolean)state.getValue((Property)Centrifuge.RUNNING)).booleanValue() && level instanceof ServerLevel) {
            blockEntity.energyHandler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false);
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = 1.0 + (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(1.0, timeUpgradeModifier);
    }

    @Override
    protected double getProcessingTimeModifier() {
        return super.getProcessingTimeModifier() / 3.0;
    }

    @Override
    protected boolean canOperate() {
        return this.energyHandler.getEnergyStored() >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    @Override
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.POWERED_CENTRIFUGE.get()).getDescriptionId());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new PoweredCentrifugeContainer(pContainerId, pPlayerInventory, this);
    }

    @Override
    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    @Override
    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }
}

