/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.crafting.ingredient;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class BeeIngredient {
    public static final Codec<Supplier<BeeIngredient>> CODEC = Codec.STRING.comapFlatMap(BeeIngredientFactory::read, BeeIngredient::write).stable();
    public static final Codec<List<Supplier<BeeIngredient>>> LIST_CODEC = Codec.list(CODEC);
    private static final Map<BeeIngredient, WeakReference<Entity>> cache = new WeakHashMap<BeeIngredient, WeakReference<Entity>>();
    private EntityType<? extends Entity> bee;
    private ResourceLocation beeType;
    private boolean configurable = false;

    public BeeIngredient(EntityType<? extends Entity> bee) {
        this.bee = bee;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType) {
        this(bee);
        this.beeType = beeType;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType, boolean isConfigurable) {
        this(bee);
        this.beeType = beeType;
        this.configurable = isConfigurable;
    }

    public EntityType<? extends Entity> getBeeEntity() {
        return this.bee;
    }

    public Entity getCachedEntity(Level world) {
        Entity entity = null;
        WeakReference<Entity> entityRef = cache.get(this);
        if (entityRef != null) {
            entity = (Entity)entityRef.get();
        }
        try {
            if (entity == null) {
                entity = this.getBeeEntity().create(world);
                if (entity instanceof ConfigurableBee) {
                    ((ConfigurableBee)entity).setBeeType(this.getBeeType().toString());
                    ((ConfigurableBee)entity).setDefaultAttributes();
                }
                cache.put(this, new WeakReference<Entity>(entity));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return entity;
    }

    public ResourceLocation getBeeType() {
        return this.beeType != null ? this.beeType : BuiltInRegistries.ENTITY_TYPE.getKey(this.bee);
    }

    public static BeeIngredient fromNetwork(FriendlyByteBuf buffer) {
        String beeName = buffer.readUtf();
        return new BeeIngredient((EntityType<? extends Entity>)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)beeName))), buffer.readResourceLocation(), buffer.readBoolean());
    }

    public final void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeUtf(String.valueOf(BuiltInRegistries.ENTITY_TYPE.getKey(this.bee)));
        buffer.writeResourceLocation(this.getBeeType());
        buffer.writeBoolean(this.configurable);
    }

    public static String write(Supplier<BeeIngredient> beeIngredient) {
        BeeIngredient ing = beeIngredient.get();
        return ing.beeType != null ? ing.beeType.toString() : BuiltInRegistries.ENTITY_TYPE.getKey(ing.bee).toString();
    }

    public String toString() {
        return "BeeIngredient{bee=" + String.valueOf(this.bee) + ", beeType=" + String.valueOf(this.beeType) + "}";
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeeIngredient that = (BeeIngredient)o;
        if (this.configurable == that.configurable && this.beeType != null && this.beeType.equals((Object)that.beeType)) {
            return true;
        }
        return this.bee.equals(that.bee);
    }

    public int hashCode() {
        return Objects.hash(BuiltInRegistries.ENTITY_TYPE.getKey(this.bee), this.beeType, this.configurable);
    }
}

