/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeFishingRecipe
implements Recipe<RecipeInput> {
    static StreamCodec<RegistryFriendlyByteBuf, HolderSet<Biome>> BIOME_STREAM = ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME);
    private static Map<BeeFishingRecipe, List<Biome>> cachedBiomes = new HashMap<BeeFishingRecipe, List<Biome>>();
    private static Map<Biome, List<BeeFishingRecipe>> cachedRecipes = new HashMap<Biome, List<BeeFishingRecipe>>();
    public final Supplier<BeeIngredient> output;
    public final HolderSet<Biome> biomes;
    public final float chance;

    public BeeFishingRecipe(Supplier<BeeIngredient> output, HolderSet<Biome> biomes, float chance) {
        this.output = output;
        this.biomes = biomes;
        this.chance = chance;
    }

    public boolean matches(RecipeInput inv, Level levelIn) {
        return false;
    }

    public boolean matches(Holder<Biome> biome, Level level) {
        if (this.biomes.size() == 0) {
            return true;
        }
        return this.biomes.contains(biome);
    }

    public static List<Biome> getBiomeList(BeeFishingRecipe recipe, Level level) {
        if (!cachedBiomes.containsKey(recipe)) {
            ArrayList<Biome> list = new ArrayList<Biome>();
            for (Holder biome : recipe.biomes) {
                list.add((Biome)biome.value());
            }
            cachedBiomes.put(recipe, list);
        }
        return cachedBiomes.get(recipe);
    }

    public static List<BeeFishingRecipe> getRecipeList(Holder<Biome> biome, Level level) {
        if (!cachedRecipes.containsKey(biome.value())) {
            ArrayList<BeeFishingRecipe> list = new ArrayList<BeeFishingRecipe>();
            List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BEE_FISHING_TYPE.get());
            for (RecipeHolder recipe : allRecipes) {
                if (!((BeeFishingRecipe)recipe.value()).matches(biome, level)) continue;
                list.add((BeeFishingRecipe)recipe.value());
            }
            cachedRecipes.put((Biome)biome.value(), list);
        }
        return cachedRecipes.get(biome.value());
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_FISHING.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BEE_FISHING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeFishingRecipe> {
        private static final MapCodec<BeeFishingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.CODEC.fieldOf("bee").forGetter(recipe -> recipe.output), (App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(recipe -> recipe.biomes), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)builder, BeeFishingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeFishingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeFishingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeFishingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeFishingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                BeeIngredient output = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                return new BeeFishingRecipe((Supplier<BeeIngredient>)Lazy.of(() -> output), (HolderSet<Biome>)((HolderSet)BIOME_STREAM.decode((Object)buffer)), buffer.readFloat());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee fishing recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeFishingRecipe recipe) {
            try {
                recipe.output.get().toNetwork((FriendlyByteBuf)buffer);
                BIOME_STREAM.encode((Object)buffer, recipe.biomes);
                buffer.writeFloat(recipe.chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee fishing recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

