/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class NetherBeehiveDecorator
extends TreeDecorator {
    public static final MapCodec<NetherBeehiveDecorator> CODEC = MapCodec.unit(NetherBeehiveDecorator::new);
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(direction -> direction != Direction.SOUTH.getOpposite()).toArray(Direction[]::new);
    private BlockState nest;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModFeatures.NETHER_BEEHIVE.get();
    }

    public void setNest(BlockState nest) {
        this.nest = nest;
    }

    public void place(TreeDecorator.Context context) {
        if (context.leaves().isEmpty() || context.logs().isEmpty()) {
            return;
        }
        int i = Math.max(((BlockPos)context.leaves().get(0)).getY() - 1, ((BlockPos)context.logs().get(0)).getY() + 1);
        List list = context.logs().stream().filter(pos -> pos.getY() == i).flatMap(pos -> Stream.of(SPAWN_DIRECTIONS).map(arg_0 -> ((BlockPos)pos).relative(arg_0))).collect(Collectors.toList());
        if (!list.isEmpty()) {
            Collections.shuffle(list);
            Optional<BlockPos> optional = list.stream().filter(pos -> context.isAir(pos) && context.isAir(pos.relative(Direction.SOUTH))).findFirst();
            if (optional.isPresent()) {
                Direction facing = Direction.SOUTH;
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    if (!context.logs().contains((Object)optional.get().relative(d))) continue;
                    facing = d.getOpposite();
                    break;
                }
                context.setBlock(optional.get(), (BlockState)this.nest.setValue((Property)BeehiveBlock.FACING, (Comparable)facing));
                context.level().getBlockEntity(optional.get(), (BlockEntityType)ModBlockEntityTypes.NETHER_BEE_NEST.get()).ifPresent(blockEntity -> {
                    int j = 2 + context.random().nextInt(2);
                    String type = BuiltInRegistries.BLOCK.getKey((Object)this.nest.getBlock()).getPath().equals("warped_bee_nest") ? "warped" : "crimson";
                    for (int k = 0; k < j; ++k) {
                        try {
                            Supplier<BeeIngredient> beeIngredient = BeeIngredientFactory.getIngredient("productivebees:" + type);
                            if (beeIngredient.get() == null) continue;
                            CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient.get());
                            blockEntity.addOccupantFromTag(bee, context.random().nextInt(599), 600);
                            continue;
                        }
                        catch (CommandSyntaxException e) {
                            ProductiveBees.LOGGER.warn("Failed to put bees into nether nest :(" + e.getMessage());
                        }
                    }
                });
            }
        }
    }
}

