/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.dungeon;

import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.entity.EntityUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoorwayBlock
extends Block {
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");
    public static final VoxelShape INVISIBLE_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private final Supplier<EntityType<?>> blockedEntityTypeSupplier;

    public DoorwayBlock(Supplier<EntityType<?>> blockedEntityTypeSupplier, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
        this.blockedEntityTypeSupplier = blockedEntityTypeSupplier;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{INVISIBLE});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCreative()) {
            BlockState newState = (BlockState)state.cycle((Property)INVISIBLE);
            level.setBlock(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        boolean flag = super.canBeReplaced(state, context);
        if (!flag) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            for (int i = 0; i < 2; ++i) {
                EntityUtil.spawnRemovalParticles(level, pos);
            }
        }
        return flag;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockItem blockItem;
        ItemStack itemStack;
        Item item;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.gameMode != null && minecraft.gameMode.getPlayerMode() == GameType.CREATIVE && minecraft.player != null && minecraft.level != null && (item = (itemStack = minecraft.player.getMainHandItem()).getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() == this && ((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            minecraft.level.addParticle((ParticleOptions)AetherParticleTypes.BOSS_DOORWAY_BLOCK.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)INVISIBLE)).booleanValue()) {
            Player player;
            EntityCollisionContext entity;
            Entity entity2;
            if (context instanceof EntityCollisionContext && (entity2 = (entity = (EntityCollisionContext)context).getEntity()) instanceof Player && (player = (Player)entity2).isCreative()) {
                return INVISIBLE_SHAPE;
            }
            return Shapes.empty();
        }
        return super.getShape(state, level, pos, context);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entity;
        if (context instanceof EntityCollisionContext && (entity = (EntityCollisionContext)context).getEntity() != null && this.blockedEntityTypeSupplier.get() != null && entity.getEntity().getType() == this.blockedEntityTypeSupplier.get()) {
            return Shapes.block();
        }
        return (Boolean)state.getValue((Property)INVISIBLE) != false ? Shapes.empty() : super.getCollisionShape(state, level, pos, context);
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)INVISIBLE) != false ? RenderShape.INVISIBLE : super.getRenderShape(state);
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.BLOCKED;
    }
}

