/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.blockentity;

import com.aetherteam.aether.block.utility.SkyrootBedBlock;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.blockentity.SkyrootBedBlockEntity;
import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SkyrootBedRenderer
implements BlockEntityRenderer<SkyrootBedBlockEntity> {
    private static final ResourceLocation BED_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"textures/entity/tiles/bed/skyroot_bed.png");
    private final ModelPart headRoot;
    private final ModelPart footRoot;

    public SkyrootBedRenderer(BlockEntityRendererProvider.Context context) {
        this.headRoot = context.bakeLayer(AetherModelLayers.SKYROOT_BED_HEAD);
        this.footRoot = context.bakeLayer(AetherModelLayers.SKYROOT_BED_FOOT);
    }

    public void render(SkyrootBedBlockEntity bed, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = bed.getLevel();
        if (level != null) {
            BlockState blockstate = bed.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult combineResult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)AetherBlockEntityTypes.SKYROOT_BED.get()), BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)bed.getBlockPos(), (levelAccessor, pos) -> false);
            int i = ((Int2IntFunction)combineResult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLight);
            this.renderPiece(poseStack, buffer, blockstate.getValue((Property)SkyrootBedBlock.PART) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.getValue((Property)SkyrootBedBlock.FACING), i, combinedOverlay, false);
        } else {
            this.renderPiece(poseStack, buffer, this.headRoot, Direction.SOUTH, combinedLight, combinedOverlay, false);
            this.renderPiece(poseStack, buffer, this.footRoot, Direction.SOUTH, combinedLight, combinedOverlay, true);
        }
    }

    private void renderPiece(PoseStack poseStack, MultiBufferSource buffer, ModelPart model, Direction direction, int packedLight, int packedOverlay, boolean foot) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5625, foot ? -1.0 : 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        poseStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)BED_LOCATION));
        model.render(poseStack, vertexconsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

