/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.passive.Aerbunny;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class AerbunnyModel
extends EntityModel<Aerbunny> {
    public final ModelPart head;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart rightWhiskers;
    public final ModelPart leftWhiskers;
    public final ModelPart body;
    public final ModelPart puff;
    public final ModelPart tail;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightBackLeg;
    public final ModelPart leftBackLeg;
    public float puffiness;

    public AerbunnyModel(ModelPart root) {
        this.head = root.getChild("head");
        this.rightEar = this.head.getChild("right_ear");
        this.leftEar = this.head.getChild("left_ear");
        this.rightWhiskers = this.head.getChild("right_whiskers");
        this.leftWhiskers = this.head.getChild("left_whiskers");
        this.body = root.getChild("body");
        this.puff = root.getChild("puff");
        this.tail = this.body.getChild("tail");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.rightBackLeg = this.body.getChild("right_back_leg");
        this.leftBackLeg = this.body.getChild("left_back_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition head = partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 4.0f, 6.0f), PartPose.offset((float)0.0f, (float)15.0f, (float)-4.0f));
        head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -5.0f, -3.0f, 1.0f, 4.0f, 2.0f), PartPose.ZERO);
        head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(14, 0).addBox(1.0f, -5.0f, -3.0f, 1.0f, 4.0f, 2.0f), PartPose.ZERO);
        head.addOrReplaceChild("right_whiskers", CubeListBuilder.create().texOffs(20, 0).addBox(-4.0f, 0.0f, -3.0f, 2.0f, 3.0f, 2.0f), PartPose.ZERO);
        head.addOrReplaceChild("left_whiskers", CubeListBuilder.create().texOffs(20, 0).addBox(2.0f, 0.0f, -3.0f, 2.0f, 3.0f, 2.0f), PartPose.ZERO);
        PartDefinition body = partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("puff", CubeListBuilder.create().texOffs(29, 0).addBox(-3.5f, -3.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 4.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.ZERO);
        body.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(24, 16).addBox(0.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)-3.0f, (float)-3.0f, (float)-3.0f));
        body.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(24, 16).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)3.0f, (float)-3.0f, (float)-3.0f));
        body.addOrReplaceChild("right_back_leg", CubeListBuilder.create().texOffs(16, 24).addBox(0.0f, 0.0f, -4.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)-3.0f, (float)4.0f, (float)-3.0f));
        body.addOrReplaceChild("left_back_leg", CubeListBuilder.create().texOffs(16, 24).addBox(-2.0f, 0.0f, -4.0f, 2.0f, 2.0f, 4.0f), PartPose.offset((float)3.0f, (float)4.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void prepareMobModel(Aerbunny aerbunny, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel((Entity)aerbunny, limbSwing, limbSwingAmount, partialTicks);
        this.puffiness = Mth.lerp((float)partialTicks, (float)aerbunny.getPuffiness(), (float)(aerbunny.getPuffiness() - aerbunny.getPuffSubtract())) / 20.0f;
    }

    public void setupAnim(Aerbunny aerbunny, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount - this.body.xRot;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount - this.body.xRot;
        this.rightBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount - this.body.xRot;
        this.leftBackLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount - this.body.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, consumer, packedLight, packedOverlay, color);
        poseStack.pushPose();
        float a = 1.0f + this.puffiness * 0.5f;
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.scale(a, a, a);
        this.puff.render(poseStack, consumer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

