/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.builders.AetherPlacedFeatureBuilders;
import com.aetherteam.aether.data.resources.registries.AetherConfiguredFeatures;
import com.aetherteam.aether.world.placementmodifier.ConfigFilter;
import com.aetherteam.aether.world.placementmodifier.DungeonBlacklistFilter;
import com.aetherteam.aether.world.placementmodifier.HolidayFilter;
import com.aetherteam.aether.world.placementmodifier.ImprovedLayerPlacementModifier;
import com.aetherteam.nitrogen.data.resources.builders.NitrogenPlacedFeatureBuilders;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class AetherPlacedFeatures {
    public static final ResourceKey<PlacedFeature> COLD_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("cold_aercloud");
    public static final ResourceKey<PlacedFeature> BLUE_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("blue_aercloud");
    public static final ResourceKey<PlacedFeature> GOLDEN_AERCLOUD_PLACEMENT = AetherPlacedFeatures.createKey("golden_aercloud");
    public static final ResourceKey<PlacedFeature> SKYROOT_MEADOW_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_meadow_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_GROVE_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_grove_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_WOODLAND_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_woodland_trees");
    public static final ResourceKey<PlacedFeature> SKYROOT_FOREST_TREES_PLACEMENT = AetherPlacedFeatures.createKey("skyroot_forest_trees");
    public static final ResourceKey<PlacedFeature> CRYSTAL_ISLAND_PLACEMENT = AetherPlacedFeatures.createKey("crystal_island");
    public static final ResourceKey<PlacedFeature> HOLIDAY_TREE_PLACEMENT = AetherPlacedFeatures.createKey("holiday_tree");
    public static final ResourceKey<PlacedFeature> GRASS_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("grass_patch");
    public static final ResourceKey<PlacedFeature> TALL_GRASS_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("tall_grass_patch");
    public static final ResourceKey<PlacedFeature> AETHER_GRASS_BONEMEAL = AetherPlacedFeatures.createKey("aether_grass_bonemeal");
    public static final ResourceKey<PlacedFeature> ENCHANTED_AETHER_GRASS_BONEMEAL = AetherPlacedFeatures.createKey("enchanted_aether_grass_bonemeal");
    public static final ResourceKey<PlacedFeature> WHITE_FLOWER_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("white_flower_patch");
    public static final ResourceKey<PlacedFeature> PURPLE_FLOWER_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("purple_flower_patch");
    public static final ResourceKey<PlacedFeature> BERRY_BUSH_PATCH_PLACEMENT = AetherPlacedFeatures.createKey("berry_bush_patch");
    public static final ResourceKey<PlacedFeature> QUICKSOIL_SHELF_PLACEMENT = AetherPlacedFeatures.createKey("quicksoil_shelf");
    public static final ResourceKey<PlacedFeature> WATER_LAKE_PLACEMENT = AetherPlacedFeatures.createKey("water_lake");
    public static final ResourceKey<PlacedFeature> WATER_SPRING_PLACEMENT = AetherPlacedFeatures.createKey("water_spring");
    public static final ResourceKey<PlacedFeature> ORE_AETHER_DIRT_PLACEMENT = AetherPlacedFeatures.createKey("aether_dirt_ore");
    public static final ResourceKey<PlacedFeature> ORE_ICESTONE_PLACEMENT = AetherPlacedFeatures.createKey("icestone_ore");
    public static final ResourceKey<PlacedFeature> ORE_AMBROSIUM_PLACEMENT = AetherPlacedFeatures.createKey("ambrosium_ore");
    public static final ResourceKey<PlacedFeature> ORE_ZANITE_PLACEMENT = AetherPlacedFeatures.createKey("zanite_ore");
    public static final ResourceKey<PlacedFeature> ORE_GRAVITITE_BURIED_PLACEMENT = AetherPlacedFeatures.createKey("gravitite_ore_buried");
    public static final ResourceKey<PlacedFeature> ORE_GRAVITITE_PLACEMENT = AetherPlacedFeatures.createKey("gravitite_ore");
    public static final ResourceKey<PlacedFeature> GOLD_DUNGEON_ISLAND_FOLIAGE = AetherPlacedFeatures.createKey("gold_dungeon_island_foliage");

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        AetherPlacedFeatures.register(context, COLD_AERCLOUD_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.COLD_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(32, 64, 7));
        AetherPlacedFeatures.register(context, BLUE_AERCLOUD_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.BLUE_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(32, 64, 24));
        AetherPlacedFeatures.register(context, GOLDEN_AERCLOUD_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.GOLDEN_AERCLOUD_CONFIGURATION), AetherPlacedFeatureBuilders.aercloudPlacement(96, 32, 75));
        AetherPlacedFeatures.register(context, CRYSTAL_ISLAND_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.CRYSTAL_ISLAND_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)50), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)96)), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, SKYROOT_MEADOW_TREES_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_GROVE_TREES_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_WOODLAND_TREES_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, SKYROOT_FOREST_TREES_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.TREES_SKYROOT_AND_GOLDEN_OAK_CONFIGURATION), AetherPlacedFeatureBuilders.treePlacement(PlacementUtils.countExtra((int)6, (float)0.1f, (int)1)));
        AetherPlacedFeatures.register(context, HOLIDAY_TREE_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.HOLIDAY_TREE_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)75), InSquarePlacement.spread(), SurfaceWaterDepthFilter.forMaxDepth((int)0), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BiomeFilter.biome(), new HolidayFilter(), PlacementUtils.filteredByBlockSurvival((Block)((Block)AetherBlocks.SKYROOT_SAPLING.get()))});
        AetherPlacedFeatures.register(context, GRASS_PATCH_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.GRASS_PATCH_CONFIGURATION), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), 4), BiomeFilter.biome(), new ConfigFilter(AetherConfig.SERVER.generate_tall_grass)});
        AetherPlacedFeatures.register(context, TALL_GRASS_PATCH_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.TALL_GRASS_PATCH_CONFIGURATION), new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)0, (int)7), RarityFilter.onAverageOnceEvery((int)32), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), 4), BiomeFilter.biome(), new ConfigFilter(AetherConfig.SERVER.generate_tall_grass)});
        AetherPlacedFeatures.register(context, AETHER_GRASS_BONEMEAL, configuredFeatures.getOrThrow(VegetationFeatures.SINGLE_PIECE_OF_GRASS), new PlacementModifier[]{PlacementUtils.isEmpty()});
        AetherPlacedFeatures.register(context, ENCHANTED_AETHER_GRASS_BONEMEAL, configuredFeatures.getOrThrow(VegetationFeatures.SINGLE_PIECE_OF_GRASS), new PlacementModifier[]{PlacementUtils.isEmpty()});
        AetherPlacedFeatures.register(context, WHITE_FLOWER_PATCH_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.WHITE_FLOWER_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), 4), BiomeFilter.biome()});
        AetherPlacedFeatures.register(context, PURPLE_FLOWER_PATCH_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.PURPLE_FLOWER_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)16), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), 4), BiomeFilter.biome()});
        AetherPlacedFeatures.register(context, BERRY_BUSH_PATCH_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.BERRY_BUSH_PATCH_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), ImprovedLayerPlacementModifier.of(Heightmap.Types.MOTION_BLOCKING, (IntProvider)UniformInt.of((int)0, (int)1), 4), BiomeFilter.biome()});
        AetherPlacedFeatures.register(context, QUICKSOIL_SHELF_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.QUICKSOIL_SHELF_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)5), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, WATER_LAKE_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.WATER_LAKE_CONFIGURATION), new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)15), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        AetherPlacedFeatures.register(context, WATER_SPRING_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.WATER_SPRING_CONFIGURATION), new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128)), BiomeFilter.biome(), new DungeonBlacklistFilter()});
        AetherPlacedFeatures.register(context, ORE_AETHER_DIRT_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_AETHER_DIRT_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128))));
        AetherPlacedFeatures.register(context, ORE_ICESTONE_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_ICESTONE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128))));
        AetherPlacedFeatures.register(context, ORE_AMBROSIUM_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_AMBROSIUM_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)20, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)128))));
        AetherPlacedFeatures.register(context, ORE_ZANITE_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_ZANITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)14, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)75))));
        AetherPlacedFeatures.register(context, ORE_GRAVITITE_BURIED_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_GRAVITITE_BURIED_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)74))));
        AetherPlacedFeatures.register(context, ORE_GRAVITITE_PLACEMENT, configuredFeatures.getOrThrow(AetherConfiguredFeatures.ORE_GRAVITITE_CONFIGURATION), NitrogenPlacedFeatureBuilders.commonOrePlacement((int)7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-58), (VerticalAnchor)VerticalAnchor.aboveBottom((int)74))));
        AetherPlacedFeatures.register(context, GOLD_DUNGEON_ISLAND_FOLIAGE, configuredFeatures.getOrThrow(AetherConfiguredFeatures.GOLD_DUNGEON_ISLAND_FOLIAGE_CONFIGURATION), new PlacementModifier[]{PlacementUtils.isEmpty(), RarityFilter.onAverageOnceEvery((int)16)});
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        AetherPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

