/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.network.packet.serverbound.StepHeightPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public interface MountableMob {
    public static final ResourceLocation MOUNT_HEIGHT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"mounted_step_height_increase");
    public static final ResourceLocation DEFAULT_HEIGHT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"default_step_height_increase");
    public static final AttributeModifier STEP_HEIGHT_MODIFIER = new AttributeModifier(MOUNT_HEIGHT_LOCATION, 0.4, AttributeModifier.Operation.ADD_VALUE);
    public static final AttributeModifier DEFAULT_STEP_HEIGHT_MODIFIER = new AttributeModifier(DEFAULT_HEIGHT_LOCATION, -0.1, AttributeModifier.Operation.ADD_VALUE);

    default public void riderTick(Mob vehicle) {
        LivingEntity livingEntity = vehicle.getControllingPassenger();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.setPlayerJumped(((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER)).isJumping());
        }
    }

    default public <T extends Mob> void tick(T vehicle) {
        if (vehicle.isAlive()) {
            LivingEntity entity = vehicle.getControllingPassenger();
            if (vehicle.isVehicle() && entity instanceof LivingEntity) {
                LivingEntity passenger = entity;
                if (((MountableMob)vehicle).getPlayerJumped() && !((MountableMob)vehicle).isMountJumping() && ((MountableMob)vehicle).canJump()) {
                    ((MountableMob)vehicle).setMountJumping(true);
                    ((MountableMob)vehicle).setPlayerJumped(false);
                }
                if (vehicle.onGround()) {
                    ((MountableMob)vehicle).setPlayerJumped(false);
                    ((MountableMob)vehicle).setMountJumping(false);
                }
                if (passenger instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)passenger;
                    ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.connection;
                    serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                    serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                }
            }
        }
    }

    default public <T extends Mob> void travel(T vehicle, Vec3 motion) {
        LivingEntity entity = vehicle.getControllingPassenger();
        if (vehicle.isVehicle() && entity instanceof LivingEntity) {
            LivingEntity passenger = entity;
            vehicle.setYRot(passenger.getYRot() % 360.0f);
            vehicle.yRotO = vehicle.getYRot();
            vehicle.setXRot(passenger.getXRot() * 0.5f % 360.0f);
            vehicle.setYBodyRot(vehicle.getYRot());
            vehicle.setYHeadRot(vehicle.yBodyRot);
            float f = passenger.xxa * 0.5f;
            float f1 = passenger.zza;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            if (((MountableMob)vehicle).getPlayerJumped() && !((MountableMob)vehicle).isMountJumping() && ((MountableMob)vehicle).canJump()) {
                MobEffectInstance jumpBoost;
                double jumpStrength = ((MountableMob)vehicle).getMountJumpStrength() * this.jumpFactor();
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().x(), jumpStrength, vehicle.getDeltaMovement().z());
                if (vehicle.hasEffect(MobEffects.JUMP) && (jumpBoost = vehicle.getEffect(MobEffects.JUMP)) != null) {
                    vehicle.push(0.0, 0.1 * (double)(jumpBoost.getAmplifier() + 1), 0.0);
                }
                vehicle.hasImpulse = true;
                ((MountableMob)vehicle).onJump(vehicle);
            } else if (((MountableMob)vehicle).getPlayerJumped() && ((MountableMob)vehicle).isMountJumping() && ((MountableMob)vehicle).canJump() && Swim.shouldSwim(vehicle)) {
                vehicle.jumpInFluid(vehicle.level().getFluidState(vehicle.getOnPos()).getFluidType());
                vehicle.hasImpulse = true;
                ((MountableMob)vehicle).onJump(vehicle);
            }
            AttributeInstance stepHeight = vehicle.getAttribute(Attributes.STEP_HEIGHT);
            if (stepHeight != null) {
                if (stepHeight.hasModifier(((MountableMob)vehicle).getDefaultStepHeightModifier().id())) {
                    stepHeight.removeModifier(((MountableMob)vehicle).getDefaultStepHeightModifier().id());
                }
                if (!stepHeight.hasModifier(((MountableMob)vehicle).getMountStepHeightModifier().id())) {
                    stepHeight.addTransientModifier(((MountableMob)vehicle).getMountStepHeightModifier());
                }
                if (vehicle.level().isClientSide()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new StepHeightPacket(vehicle.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (vehicle.isControlledByLocalInstance()) {
                vehicle.setSpeed(((MountableMob)vehicle).getSteeringSpeed());
                this.travelWithInput(new Vec3((double)f, motion.y, (double)f1));
            } else if (passenger instanceof Player) {
                vehicle.setDeltaMovement(Vec3.ZERO);
            }
            vehicle.calculateEntityAnimation(false);
        } else {
            AttributeInstance stepHeight = vehicle.getAttribute(Attributes.STEP_HEIGHT);
            if (stepHeight != null) {
                if (stepHeight.hasModifier(((MountableMob)vehicle).getMountStepHeightModifier().id())) {
                    stepHeight.removeModifier(((MountableMob)vehicle).getMountStepHeightModifier().id());
                }
                if (!stepHeight.hasModifier(((MountableMob)vehicle).getDefaultStepHeightModifier().id())) {
                    stepHeight.addTransientModifier(((MountableMob)vehicle).getDefaultStepHeightModifier());
                }
            }
            this.travelWithInput(motion);
        }
    }

    public void travelWithInput(Vec3 var1);

    public boolean getPlayerJumped();

    public void setPlayerJumped(boolean var1);

    public boolean canJump();

    public double getMountJumpStrength();

    public boolean isMountJumping();

    public void setMountJumping(boolean var1);

    public float getSteeringSpeed();

    public double jumpFactor();

    default public void onJump(Mob vehicle) {
        CommonHooks.onLivingJump((LivingEntity)vehicle);
    }

    default public AttributeModifier getMountStepHeightModifier() {
        return STEP_HEIGHT_MODIFIER;
    }

    default public AttributeModifier getDefaultStepHeightModifier() {
        return DEFAULT_STEP_HEIGHT_MODIFIER;
    }
}

