/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.rei;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherDataMaps;
import com.aetherteam.aether.integration.rei.AetherREIServerPlugin;
import com.aetherteam.aether.integration.rei.FuelRecipe;
import com.aetherteam.aether.integration.rei.categories.ban.BlockBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.ItemBanRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.ban.PlacementBanRecipeDisplay;
import com.aetherteam.aether.integration.rei.categories.block.AetherBlockStateRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.block.BiomeParameterRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeCategory;
import com.aetherteam.aether.integration.rei.categories.item.AetherCookingRecipeDisplay;
import com.aetherteam.aether.inventory.menu.AltarMenu;
import com.aetherteam.aether.inventory.menu.FreezerMenu;
import com.aetherteam.aether.inventory.menu.IncubatorMenu;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.AccessoryFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.AmbrosiumRecipe;
import com.aetherteam.aether.recipe.recipes.block.IcestoneFreezableRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import com.aetherteam.aether.recipe.recipes.block.SwetBallRecipe;
import com.aetherteam.aether.recipe.recipes.item.AltarRepairRecipe;
import com.aetherteam.aether.recipe.recipes.item.EnchantingRecipe;
import com.aetherteam.aether.recipe.recipes.item.FreezingRecipe;
import com.aetherteam.aether.recipe.recipes.item.IncubationRecipe;
import com.aetherteam.nitrogen.integration.rei.categories.fuel.AbstractFuelCategory;
import com.aetherteam.nitrogen.integration.rei.displays.BlockStateRecipeDisplay;
import com.aetherteam.nitrogen.integration.rei.displays.FuelDisplay;
import com.aetherteam.nitrogen.recipe.recipes.AbstractBlockStateRecipe;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@REIPluginClient
public class AetherREIClientPlugin
implements REIClientPlugin {
    private static final ResourceLocation LIT_PROGRESS_TRANSPARENT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"menu/lit_progress_transparent");
    private static final ResourceLocation LIT_PROGRESS_BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"menu/lit_progress_background");

    public static List<FuelRecipe> getFuelRecipes() {
        ArrayList<FuelRecipe> fuelRecipes = new ArrayList<FuelRecipe>();
        BuiltInRegistries.ITEM.getDataMap(AetherDataMaps.ALTAR_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(item))), fuel.burnTime(), (Block)AetherBlocks.ALTAR.get())));
        BuiltInRegistries.ITEM.getDataMap(AetherDataMaps.FREEZER_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(item))), fuel.burnTime(), (Block)AetherBlocks.FREEZER.get())));
        BuiltInRegistries.ITEM.getDataMap(AetherDataMaps.INCUBATOR_FUEL).forEach((item, fuel) -> fuelRecipes.add(new FuelRecipe(List.of(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(item))), fuel.burnTime(), (Block)AetherBlocks.INCUBATOR.get())));
        return fuelRecipes;
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(ItemBanRecipe.class, (RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get(), recipe -> PlacementBanRecipeDisplay.ofItem((ItemBanRecipe)recipe.value()));
        registry.registerRecipeFiller(BlockBanRecipe.class, (RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get(), recipe -> PlacementBanRecipeDisplay.ofBlock((BlockBanRecipe)recipe.value()));
        registry.registerRecipeFiller(AccessoryFreezableRecipe.class, (RecipeType)AetherRecipeTypes.ACCESSORY_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ACCESSORY_FREEZABLE, (AbstractBlockStateRecipe)((AccessoryFreezableRecipe)recipe.value())));
        registry.registerRecipeFiller(AmbrosiumRecipe.class, (RecipeType)AetherRecipeTypes.AMBROSIUM_ENCHANTING.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.AMBROSIUM_ENCHANTING, (AbstractBlockStateRecipe)((AmbrosiumRecipe)recipe.value())));
        registry.registerRecipeFiller(IcestoneFreezableRecipe.class, (RecipeType)AetherRecipeTypes.ICESTONE_FREEZABLE.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.ICESTONE_FREEZABLE, (AbstractBlockStateRecipe)((IcestoneFreezableRecipe)recipe.value())));
        registry.registerRecipeFiller(PlacementConversionRecipe.class, (RecipeType)AetherRecipeTypes.PLACEMENT_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.PLACEMENT_CONVERSION, (AbstractBlockStateRecipe)((PlacementConversionRecipe)recipe.value())));
        registry.registerRecipeFiller(SwetBallRecipe.class, (RecipeType)AetherRecipeTypes.SWET_BALL_CONVERSION.get(), recipe -> new BlockStateRecipeDisplay(AetherREIServerPlugin.SWET_BALL_CONVERSION, (AbstractBlockStateRecipe)((SwetBallRecipe)recipe.value())));
        for (FuelRecipe fuelRecipe : AetherREIClientPlugin.getFuelRecipes()) {
            registry.add((Display)new FuelDisplay(AetherREIServerPlugin.AETHER_FUEL, fuelRecipe.inputItems(), fuelRecipe.burnTime(), fuelRecipe.usageBlock()));
        }
        for (RecipeHolder recipe2 : registry.getRecipeManager().getAllRecipesFor((RecipeType)AetherRecipeTypes.ENCHANTING.get())) {
            Recipe recipe3 = recipe2.value();
            if (recipe3 instanceof EnchantingRecipe) {
                EnchantingRecipe enchanting = (EnchantingRecipe)recipe3;
                registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_ENCHANTING, enchanting));
                continue;
            }
            recipe3 = recipe2.value();
            if (!(recipe3 instanceof AltarRepairRecipe)) continue;
            AltarRepairRecipe repair = (AltarRepairRecipe)recipe3;
            registry.add(AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_REPAIR, repair));
        }
        registry.registerFiller(o -> {
            RecipeHolder holder;
            return o instanceof RecipeHolder && (holder = (RecipeHolder)o).value() instanceof EnchantingRecipe;
        }, recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_ENCHANTING, (EnchantingRecipe)((RecipeHolder)recipe).value()));
        registry.registerFiller(o -> {
            RecipeHolder holder;
            return o instanceof RecipeHolder && (holder = (RecipeHolder)o).value() instanceof AltarRepairRecipe;
        }, recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.ALTAR_REPAIR, (AltarRepairRecipe)((RecipeHolder)recipe).value()));
        registry.registerRecipeFiller(FreezingRecipe.class, (RecipeType)AetherRecipeTypes.FREEZING.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.FREEZING, (FreezingRecipe)recipe.value()));
        registry.registerRecipeFiller(IncubationRecipe.class, (RecipeType)AetherRecipeTypes.INCUBATION.get(), recipe -> AetherCookingRecipeDisplay.of(AetherREIServerPlugin.INCUBATING, (IncubationRecipe)recipe.value()));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new BlockBanRecipeCategory());
        registry.add((DisplayCategory)new ItemBanRecipeCategory());
        registry.add(AetherBlockStateRecipeCategory.accessoryFreezable());
        registry.add(AetherBlockStateRecipeCategory.ambrosium());
        registry.add(AetherBlockStateRecipeCategory.icestoneFreezable());
        registry.add(BiomeParameterRecipeCategory.placementConversion());
        registry.add(BiomeParameterRecipeCategory.swetBall());
        registry.add((DisplayCategory)new AbstractFuelCategory(this, AetherREIServerPlugin.AETHER_FUEL, LIT_PROGRESS_TRANSPARENT_TEXTURE, LIT_PROGRESS_BACKGROUND_TEXTURE){

            public Component getTitle() {
                return Component.translatable((String)"gui.aether.jei.fuel");
            }
        });
        registry.add(AetherCookingRecipeCategory.altarRepair());
        registry.add(AetherCookingRecipeCategory.altarEnchanting());
        registry.add(AetherCookingRecipeCategory.freezing());
        registry.add(AetherCookingRecipeCategory.incubating());
        registry.addWorkstations(AetherREIServerPlugin.AETHER_FUEL, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get())), EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get())), EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.FREEZING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.FREEZER.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_REPAIR, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.ALTAR_ENCHANTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.ALTAR.get()))});
        registry.addWorkstations(AetherREIServerPlugin.INCUBATING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AetherBlocks.INCUBATOR.get()))});
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_ENCHANTING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(AltarMenu.class, AetherREIServerPlugin.ALTAR_REPAIR, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(FreezerMenu.class, AetherREIServerPlugin.FREEZING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
        registry.register((TransferHandler)SimpleTransferHandler.create(IncubatorMenu.class, AetherREIServerPlugin.INCUBATING, (SimpleTransferHandler.IntRange)new SimpleTransferHandler.IntRange(0, 1)));
    }
}

