/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.inventory.menu;

import com.aetherteam.aether.inventory.container.LoreInventory;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LoreBookMenu
extends AbstractContainerMenu {
    private static final Map<Function<RegistryAccess, Predicate<ItemStack>>, String> LORE_ENTRY_OVERRIDES = new HashMap<Function<RegistryAccess, Predicate<ItemStack>>, String>();
    private final LoreInventory loreInventory;
    private boolean loreEntryExists;

    public LoreBookMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new LoreInventory(playerInventory.player));
    }

    public LoreBookMenu(int id, Inventory playerInventory, LoreInventory loreInventory) {
        super((MenuType)AetherMenuTypes.BOOK_OF_LORE.get(), id);
        LoreBookMenu.checkContainerSize((Container)loreInventory, (int)1);
        this.loreInventory = loreInventory;
        loreInventory.setMenu(this);
        loreInventory.startOpen(playerInventory.player);
        this.addSlot(new Slot((Container)loreInventory, 0, 83, 63));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + k * 9 + 9, 48 + i1 * 18, 113 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 48 + l * 18, 171));
        }
    }

    public boolean stillValid(Player player) {
        return this.loreInventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack1 = slot.getItem();
            itemStack = itemStack1.copy();
            if (index < 1 ? !this.moveItemStackTo(itemStack1, 1, 37, true) : !this.moveItemStackTo(itemStack1, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack1.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack1);
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = this.loreInventory.getItem(0);
            if (!stack.isEmpty()) {
                if (player.isAlive() && !serverPlayer.hasDisconnected()) {
                    player.getInventory().placeItemBackInInventory(stack);
                } else {
                    player.drop(stack, false);
                }
                this.loreInventory.setItem(0, ItemStack.EMPTY);
            }
        }
        this.loreInventory.stopOpen(player);
    }

    public boolean getLoreEntryExists() {
        return this.loreEntryExists;
    }

    public void setLoreEntryExists(boolean loreEntryExists) {
        this.loreEntryExists = loreEntryExists;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLoreEntryOverride(Function<RegistryAccess, Predicate<ItemStack>> predicate, String entry) {
        LORE_ENTRY_OVERRIDES.putIfAbsent(predicate, entry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getLoreEntryKey(ItemStack stack) {
        Optional<String> key = LORE_ENTRY_OVERRIDES.entrySet().stream().filter(e -> ((Predicate)((Function)e.getKey()).apply(this.loreInventory.player.registryAccess())).test(stack)).findAny().map(Map.Entry::getValue);
        return key.orElseGet(() -> "lore." + stack.getDescriptionId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean loreEntryKeyExists(ItemStack stack) {
        return I18n.exists((String)this.getLoreEntryKey(stack));
    }
}

