/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.network.packet.clientbound.ClientGrabItemPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenInventoryPacket(ItemStack carryStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenInventoryPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"open_vanilla_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenInventoryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, OpenInventoryPacket::carryStack, OpenInventoryPacket::new);

    public CustomPacketPayload.Type<OpenInventoryPacket> type() {
        return TYPE;
    }

    public static void execute(OpenInventoryPacket payload, IPayloadContext context) {
        Player playerEntity = context.player();
        if (playerEntity.getServer() != null && playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ItemStack itemStack = serverPlayer.isCreative() ? payload.carryStack() : serverPlayer.containerMenu.getCarried();
            serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
            serverPlayer.doCloseContainer();
            if (!itemStack.isEmpty() && !serverPlayer.isCreative()) {
                serverPlayer.containerMenu.setCarried(itemStack);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientGrabItemPacket(itemStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

