/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.entity.passive.MountableAnimal;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record StepHeightPacket(int entityID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StepHeightPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"sync_step_height"));
    public static final StreamCodec<RegistryFriendlyByteBuf, StepHeightPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, StepHeightPacket::entityID, StepHeightPacket::new);

    public CustomPacketPayload.Type<StepHeightPacket> type() {
        return TYPE;
    }

    public static void execute(StepHeightPacket payload, IPayloadContext context) {
        MountableAnimal mountableAnimal;
        AttributeInstance stepHeight;
        Entity entity;
        Player playerEntity = context.player();
        if (playerEntity.getServer() != null && (entity = playerEntity.level().getEntity(payload.entityID())) instanceof MountableAnimal && (stepHeight = (mountableAnimal = (MountableAnimal)entity).getAttribute(Attributes.STEP_HEIGHT)) != null) {
            if (stepHeight.hasModifier(mountableAnimal.getDefaultStepHeightModifier().id())) {
                stepHeight.removeModifier(mountableAnimal.getDefaultStepHeightModifier().id());
            }
            if (!stepHeight.hasModifier(mountableAnimal.getMountStepHeightModifier().id())) {
                stepHeight.addTransientModifier(mountableAnimal.getMountStepHeightModifier());
            }
        }
    }
}

