/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;

public final class MountHelpers {
    private MountHelpers() {
    }

    public static String getReason(FileSystemException exn) {
        if (exn instanceof FileAlreadyExistsException) {
            return "File exists";
        }
        if (exn instanceof NoSuchFileException) {
            return "No such file";
        }
        if (exn instanceof NotDirectoryException) {
            return "Not a directory";
        }
        if (exn instanceof AccessDeniedException) {
            return "Access denied";
        }
        String reason = exn.getReason();
        return reason != null ? reason.trim() : "Operation failed";
    }
}

