/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public enum UserLevel implements Predicate<CommandSourceStack>
{
    OP,
    OWNER_OP,
    ANYONE;


    public int toLevel() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> 2;
            case 2 -> 0;
        };
    }

    @Override
    public boolean test(CommandSourceStack source) {
        if (this == ANYONE) {
            return true;
        }
        if (this == OWNER_OP && UserLevel.isOwner(source)) {
            return true;
        }
        return source.hasPermission(this.toLevel());
    }

    @Override
    public boolean test(ServerPlayer source) {
        if (this == ANYONE) {
            return true;
        }
        if (this == OWNER_OP && UserLevel.isOwner(source)) {
            return true;
        }
        return source.hasPermissions(this.toLevel());
    }

    public static boolean isOwner(CommandSourceStack source) {
        MinecraftServer server = source.getServer();
        if (server == null) {
            return false;
        }
        ServerPlayer player = source.getPlayer();
        return server.isDedicatedServer() ? source.getEntity() == null && source.hasPermission(4) && source.getTextName().equals("Server") : player != null && server.isSingleplayerOwner(player.getGameProfile());
    }

    public static boolean isOwner(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        return server != null && server.isSingleplayerOwner(player.getGameProfile());
    }
}

