/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.serialization.Codec;
import dan200.computercraft.api.ComputerCraftAPI;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public record NonNegativeId(int id) {
    public static final Codec<NonNegativeId> CODEC = ExtraCodecs.NON_NEGATIVE_INT.xmap(NonNegativeId::new, NonNegativeId::id);
    public static final StreamCodec<ByteBuf, NonNegativeId> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(NonNegativeId::new, NonNegativeId::id);

    public NonNegativeId {
        if (id < 0) {
            throw new IllegalArgumentException("ID must be >= 0");
        }
    }

    public static int getId(@Nullable NonNegativeId id) {
        return id == null ? -1 : id.id();
    }

    public static @Nullable NonNegativeId of(int id) {
        return id >= 0 ? new NonNegativeId(id) : null;
    }

    public static int getOrCreate(MinecraftServer server, ItemStack stack, DataComponentType<NonNegativeId> component, String type) {
        NonNegativeId id = (NonNegativeId)stack.get(component);
        if (id != null) {
            return id.id();
        }
        int diskID = ComputerCraftAPI.createUniqueNumberedSaveDir(server, type);
        stack.set(component, (Object)new NonNegativeId(diskID));
        return diskID;
    }

    public void addToTooltip(String translation, Consumer<Component> out) {
        out.accept((Component)Component.translatable((String)translation, (Object[])new Object[]{this.id()}).withStyle(ChatFormatting.GRAY));
    }
}

